package eu.dnetlib.data.collector.plugins.ariadneplus.ehri;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;

import eu.dnetlib.rmi.data.CollectorServiceException;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by Alessia Bardi on 03/05/2017.
 *
 * @author Alessia Bardi
 */
public class EHRIIteratorFactory {

	@Autowired
	private EHRIGraphQLClient ehriGraphQLClient;

	public Iterator<String> newIterator(final String baseURLIdentifiers, final String queryIdentifiers,
			final String baseUrl,
			final String suffix) {
		try {
			Iterator<String> ids = ehriGraphQLClient.collect(baseURLIdentifiers, queryIdentifiers);
			return new EHRIIterator(ids, baseUrl, suffix);
		} catch (CollectorServiceException | IOException | URISyntaxException e) {
			throw new RuntimeException(e);
		}
	}

	public EHRIGraphQLClient getEhriGraphQLClient() {
		return ehriGraphQLClient;
	}

	public void setEhriGraphQLClient(final EHRIGraphQLClient ehriGraphQLClient) {
		this.ehriGraphQLClient = ehriGraphQLClient;
	}
}
