package eu.dnetlib.ariadneplus.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.client.RestTemplate;

/**
 * Created by Alessia Bardi on 26/01/2018.
 *
 * @author Alessia Bardi
 */
public class ReadVirtuosoByTypeJobNode extends ReadVirtuosoJobNode {

	private static final Log log = LogFactory.getLog(ReadVirtuosoByTypeJobNode.class);

	private String typeNamespace;
	private String typeName;

	@Override
	protected String execute(final Env env){
		log.info("Using virtuoso reader at : " + getVirtuosoReaderAPIUrl());
		RestTemplate restTemplate = new RestTemplate(getClientHttpRequestFactory());

		VirtuosoAriadnePlusByTypeIterator iterator = new VirtuosoAriadnePlusByTypeIterator().typeNamespace(typeNamespace).typeName(typeName).datasourceInterface(getDatasourceInterface()).virtuosoReaderAPIUrl(getVirtuosoReaderAPIUrl()).datasourceName(getDatasourceName()).restTemplate(restTemplate);
		log.debug(String.format("Created iterator for %s:%s : ", typeNamespace, typeName ));
		ResultSet<String> rs = getRsFactory().createResultSet(() -> iterator);

		env.setAttribute("virtuoso_rs", rs);

		return Arc.DEFAULT_ARC;
	}

	public String getTypeNamespace() {
		return typeNamespace;
	}

	public void setTypeNamespace(final String typeNamespace) {
		this.typeNamespace = typeNamespace;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(final String typeName) {
		this.typeName = typeName;
	}
}
