package eu.dnetlib.data.collector.plugins.ariadneplus.ehri;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;

/**
 * This collector plugins collects metadata records from the EHRI portal export URL in the form https://portal.ehri-project.eu/units/<ID>/export.
 * IDs of units are retrieved from the EHRI GraphQL API, see docs at https://portal.ehri-project.eu/api/graphql
 * Created by Alessia Bardi on 19/04/2017.
 *
 * @author Alessia Bardi
 */
public class EHRICollectorPlugin extends AbstractCollectorPlugin {

	private EHRIIteratorFactory ehriIteratorFactory;

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {

		// https://portal.ehri-project.eu/units
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		// export
		final String suffixToUrl = interfaceDescriptor.getParams().get("suffixToBaseUrl");

		//info to get the identifiers from the graphQL API:
		final String graphQLURL = interfaceDescriptor.getParams().get("graphQLURL");
		final String graphQLQuery = interfaceDescriptor.getParams().get("graphQLQuery");

		return () ->  ehriIteratorFactory.newIterator(graphQLURL, graphQLQuery, baseUrl, suffixToUrl);
	}

	public EHRIIteratorFactory getEhriIteratorFactory() {
		return ehriIteratorFactory;
	}

	public void setEhriIteratorFactory(final EHRIIteratorFactory ehriIteratorFactory) {
		this.ehriIteratorFactory = ehriIteratorFactory;
	}
}
