/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.ehri;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.rmi.data.CollectorServiceRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EHRIIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(EHRIIterator.class);
    private static int MAX_FAILED = 100;
    private Iterator<String> identifiers;
    private String baseUrl;
    private String suffix;
    private int failed = 0;

    public EHRIIterator(Iterator<String> idIterator, String baseUrl, String suffix) {
        this.identifiers = idIterator;
        this.baseUrl = baseUrl;
        this.suffix = suffix;
    }

    public boolean doHasNext() {
        return this.identifiers.hasNext();
    }

    public String doNext() {
        String target = this.baseUrl + "/" + this.identifiers.next() + "/" + this.suffix;
        log.debug((Object)("Getting " + target));
        try {
            URL url = new URL(target);
            String record = IOUtils.toString((URL)url, (String)"UTF-8");
            return this.removeDefaultEADNamespace(record);
        }
        catch (IOException e) {
            log.error((Object)("Unable to get " + target), (Throwable)e);
            ++this.failed;
            if (this.failed > MAX_FAILED) {
                throw new CollectorServiceRuntimeException("Could not download more than " + MAX_FAILED + "documents from EHRI. Stopping.");
            }
            if (this.hasNext()) {
                return this.next();
            }
            return "";
        }
    }

    protected String removeDefaultEADNamespace(String xml) {
        try {
            VTDGen vg = new VTDGen();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            vg.setDoc(xml.getBytes());
            vg.parse(false);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            XMLModifier xm = new XMLModifier(vn);
            ap.selectXPath("/ead/@xmlns");
            int i = 0;
            while ((i = ap.evalXPath()) != -1) {
                xm.remove();
            }
            xm.output((OutputStream)baos);
            return baos.toString();
        }
        catch (Exception e) {
            log.error((Object)("Cannot remove default namespace from ead element: " + xml));
            throw new CollectorServiceRuntimeException("Cannot remove default namespace from ead element", (Throwable)e);
        }
    }

    public Iterator<String> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Iterator<String> identifiers) {
        this.identifiers = identifiers;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

