/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.datasource.DatasourceManagerServiceException;
import eu.dnetlib.rmi.datasource.IfaceDesc;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClarinFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Log log = LogFactory.getLog(ClarinFileVisitor.class);
    private static final String API_PREFIX = "api_________::";
    private static final String TDS_TEMPLATE = "/eu/dnetlib/ariadneplus/workflows/nodes/clarin_tds.xml.st";
    private List<String> interfaces = Lists.newArrayList();
    private String clarinDatasourceProfileID;
    private String clarinDatasourceOriginalId;
    private DatasourceManagerService dsMan = null;
    private String inputBaseUrlPrefix;
    private String metadataIdentifierPath;
    private ISLookUpClient lookupClient;
    private ISRegistryService registryService;
    private int countVisitedFiles = 0;
    private int countCreatedTDS = 0;
    private int countUpdatedTDS = 0;
    private int countVisitedFolders = 0;
    private int countCreatedInterfaces = 0;

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        log.info((Object)("Processing " + dir.toString()));
        ++this.countVisitedFolders;
        String dirName = dir.getFileName().toString();
        if (dirName.equalsIgnoreCase("x3ml-mappings")) {
            return FileVisitResult.CONTINUE;
        }
        String apiId = API_PREFIX + this.getClarinDatasourceOriginalId() + "::" + dirName;
        if (!this.interfaces.contains(apiId)) {
            IfaceDesc iface = new IfaceDesc();
            iface.setActive(false);
            iface.setCompliance("metadata");
            iface.setContentDescription("metadata");
            iface.setId(apiId);
            iface.setRemovable(true);
            iface.setTypology("dnet:repository::clarin");
            iface.setAccessProtocol("filesystem");
            HashMap accessParams = Maps.newHashMap();
            accessParams.put("extensions", "xml");
            iface.setAccessParams((Map)accessParams);
            iface.setBaseUrl(StringUtils.appendIfMissing((String)this.getInputBaseUrlPrefix(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + dirName);
            HashMap extraFields = Maps.newHashMap();
            extraFields.put("metadata_identifier_path", this.getMetadataIdentifierPath());
            iface.setExtraFields((Map)extraFields);
            try {
                this.dsMan.addInterface(this.getClarinDatasourceProfileID(), iface);
                ++this.countCreatedInterfaces;
                log.info((Object)("CREATED NEW INTERFACE " + iface.getId() + " for " + this.getClarinDatasourceOriginalId() + "(" + this.getClarinDatasourceProfileID() + ")"));
            }
            catch (DatasourceManagerServiceException e) {
                log.error((Object)("Can't add interface " + iface.getId() + " to " + this.getClarinDatasourceOriginalId() + "(" + this.getClarinDatasourceProfileID() + ")"), (Throwable)e);
                return FileVisitResult.CONTINUE;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Interface " + apiId + " already exists"));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String filename = file.getFileName().toString();
        log.info((Object)("Processing " + file.toString()));
        ++this.countVisitedFiles;
        String tdsTitle = filename;
        String updatedCode = Files.lines(file).collect(Collectors.joining()).replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        try {
            List res = this.lookupClient.search("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value=\"TransformationRuleDSResourceType\" and .//CONFIGURATION/SCRIPT/TITLE/string()=\"" + tdsTitle + "\"]/HEADER/RESOURCE_IDENTIFIER/@value/string()");
            if (res == null || res.isEmpty()) {
                log.debug((Object)("Creating new TDS profile for " + filename));
                String template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(TDS_TEMPLATE), (Charset)Charset.forName("UTF-8"));
                StringTemplate st = new StringTemplate(template);
                st.setAttribute("date", (Object)DateUtils.calculate_ISO8601((long)DateUtils.now()));
                st.setAttribute("title", (Object)tdsTitle);
                st.setAttribute("mapping", (Object)("<![CDATA[" + updatedCode + "]]>"));
                String profId = this.registryService.registerProfile(st.toString());
                ++this.countCreatedTDS;
                log.info((Object)("REGISTERED NEW TDS FOR " + filename + ": " + profId));
            } else {
                String tdsProfileId = (String)res.get(0);
                log.debug((Object)("Updating TDS profile " + tdsProfileId + "for " + filename));
                boolean done = this.registryService.updateProfileNode(tdsProfileId, "//CONFIGURATION/SCRIPT/CODE", "<CODE><![CDATA[" + updatedCode + "]]></CODE>");
                if (done) {
                    log.info((Object)("TDS PROFILE " + tdsProfileId + " UPDATED with contents from " + filename));
                    ++this.countUpdatedTDS;
                }
                if (!done) {
                    log.error((Object)("!!! TDS PROFILE " + tdsProfileId + " COULD NOT BE UPDATED with contents from " + filename));
                }
            }
        }
        catch (ISLookUpException | ISRegistryException e) {
            log.error((Object)("CANNOT UPDATE/CREATE TDS PROFILE FOR " + filename), e);
        }
        return FileVisitResult.CONTINUE;
    }

    protected ClarinFileVisitor() {
    }

    public ClarinFileVisitor(String clarinDatasourceProfileID, String clarinDatasourceOriginalId, String inputBaseUrlPrefix, String metadataIdentifierPath, List<String> interfaces, UniqueServiceLocator locator, ISLookUpClient lookupClient) {
        this.clarinDatasourceOriginalId = clarinDatasourceOriginalId;
        this.clarinDatasourceProfileID = clarinDatasourceProfileID;
        this.inputBaseUrlPrefix = inputBaseUrlPrefix;
        this.metadataIdentifierPath = metadataIdentifierPath;
        this.interfaces = interfaces;
        this.dsMan = (DatasourceManagerService)locator.getService(DatasourceManagerService.class);
        this.registryService = (ISRegistryService)locator.getService(ISRegistryService.class);
        this.lookupClient = lookupClient;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    public String getClarinDatasourceOriginalId() {
        return this.clarinDatasourceOriginalId;
    }

    public void setClarinDatasourceOriginalId(String clarinDatasourceOriginalId) {
        this.clarinDatasourceOriginalId = clarinDatasourceOriginalId;
    }

    public DatasourceManagerService getDsMan() {
        return this.dsMan;
    }

    public void setDsMan(DatasourceManagerService dsMan) {
        this.dsMan = dsMan;
    }

    public String getInputBaseUrlPrefix() {
        return this.inputBaseUrlPrefix;
    }

    public void setInputBaseUrlPrefix(String inputBaseUrlPrefix) {
        this.inputBaseUrlPrefix = inputBaseUrlPrefix;
    }

    public String getMetadataIdentifierPath() {
        return this.metadataIdentifierPath;
    }

    public void setMetadataIdentifierPath(String metadataIdentifierPath) {
        this.metadataIdentifierPath = metadataIdentifierPath;
    }

    public String getClarinDatasourceProfileID() {
        return this.clarinDatasourceProfileID;
    }

    public void setClarinDatasourceProfileID(String clarinDatasourceProfileID) {
        this.clarinDatasourceProfileID = clarinDatasourceProfileID;
    }

    public ISLookUpClient getLookupClient() {
        return this.lookupClient;
    }

    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public ISRegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(ISRegistryService registryService) {
        this.registryService = registryService;
    }

    public int getCountVisitedFiles() {
        return this.countVisitedFiles;
    }

    public void setCountVisitedFiles(int countVisitedFiles) {
        this.countVisitedFiles = countVisitedFiles;
    }

    public int getCountCreatedTDS() {
        return this.countCreatedTDS;
    }

    public void setCountCreatedTDS(int countCreatedTDS) {
        this.countCreatedTDS = countCreatedTDS;
    }

    public int getCountUpdatedTDS() {
        return this.countUpdatedTDS;
    }

    public void setCountUpdatedTDS(int countUpdatedTDS) {
        this.countUpdatedTDS = countUpdatedTDS;
    }

    public int getCountVisitedFolders() {
        return this.countVisitedFolders;
    }

    public void setCountVisitedFolders(int countVisitedFolders) {
        this.countVisitedFolders = countVisitedFolders;
    }

    public int getCountCreatedInterfaces() {
        return this.countCreatedInterfaces;
    }

    public void setCountCreatedInterfaces(int countCreatedInterfaces) {
        this.countCreatedInterfaces = countCreatedInterfaces;
    }
}

