/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import eu.dnetlib.ariadneplus.workflows.nodes.VirtuosoAriadnePlusIterator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class ReadVirtuosoJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(ReadVirtuosoJobNode.class);
    private String datasourceName;
    private String datasourceInterface;
    private String virtuosoReaderAPIUrl;
    private int readTimeout = 30000;
    @Autowired
    private ResultSetFactory rsFactory;

    protected String execute(Env env) {
        log.info((Object)("Using virtuoso reader at : " + this.getVirtuosoReaderAPIUrl()));
        RestTemplate restTemplate = new RestTemplate(this.getClientHttpRequestFactory());
        VirtuosoAriadnePlusIterator iterator = new VirtuosoAriadnePlusIterator().datasourceInterface(this.getDatasourceInterface()).virtuosoReaderAPIUrl(this.getVirtuosoReaderAPIUrl()).datasourceName(this.getDatasourceName()).restTemplate(restTemplate);
        ResultSet rs = this.rsFactory.createResultSet(() -> iterator);
        env.setAttribute("virtuoso_rs", (Object)rs);
        return Arc.DEFAULT_ARC;
    }

    protected ClientHttpRequestFactory getClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setReadTimeout(this.readTimeout);
        return clientHttpRequestFactory;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getVirtuosoReaderAPIUrl() {
        return this.virtuosoReaderAPIUrl;
    }

    public void setVirtuosoReaderAPIUrl(String virtuosoReaderAPIUrl) {
        this.virtuosoReaderAPIUrl = virtuosoReaderAPIUrl;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }
}

