/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.isidore;

import com.google.common.collect.Maps;
import eu.dnetlib.miscutils.functional.xml.SaxonHelper;
import eu.dnetlib.rmi.data.CollectorServiceException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IsidoreIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(IsidoreIterator.class);
    private SaxonHelper saxonHelper;
    private Queue<String> recordQueue = new PriorityBlockingQueue<String>();
    private InputStream resultStream;
    private String query;
    private String querySize;
    private String queryPage;
    private int resultTotal = -1;
    private String baseUrl;
    private String queryParams;
    private String pageParam;
    private int page;
    private String pageSizeParam;
    private int pageSize;
    private XPathSelector xprEntity;
    private XPathSelector xprResultTotalPath;
    private XPathSelector xprNextPagePath;

    public IsidoreIterator(SaxonHelper saxonHelper, String baseUrl, String queryParams, String pageParam, int startFromPage, String nextPagePath, String pageSizeParam, int pageSize, String resultTotalXpath, String entityXpath) {
        this.saxonHelper = saxonHelper;
        this.baseUrl = baseUrl;
        this.queryParams = queryParams;
        this.pageParam = pageParam;
        this.page = startFromPage;
        this.queryPage = this.pageParam + "=" + this.page;
        this.pageSizeParam = pageSizeParam;
        this.pageSize = pageSize;
        this.querySize = this.pageSizeParam + "=" + this.pageSize;
        try {
            this.initXpathSelector(resultTotalXpath, nextPagePath, entityXpath);
        }
        catch (Exception e) {
            throw new IllegalStateException("xml transformation init failed: " + e.getMessage());
        }
        this.initQuery();
    }

    private void initXpathSelector(String resultTotalXpath, String nextPagePath, String entityXpath) throws SaxonApiException {
        this.xprResultTotalPath = this.saxonHelper.help().prepareXPathSelector(resultTotalXpath, (Map)Maps.newHashMap());
        this.xprNextPagePath = this.saxonHelper.help().prepareXPathSelector(nextPagePath, (Map)Maps.newHashMap());
        this.xprEntity = this.saxonHelper.help().prepareXPathSelector(entityXpath, (Map)Maps.newHashMap());
    }

    private void initQuery() {
        this.query = this.baseUrl + "?" + this.queryParams + "&" + this.querySize + "&" + this.queryPage;
    }

    private void disconnect() {
    }

    @Override
    public boolean hasNext() {
        if (this.recordQueue.isEmpty() && this.query.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    log.info((Object)("get Query: " + this.query));
                    this.query = this.downloadPage(this.query);
                    log.debug((Object)("next queryURL from downloadPage(): " + this.query));
                }
                catch (CollectorServiceException e) {
                    log.debug((Object)("CollectorPlugin.next()-Exception: " + (Object)((Object)e)));
                    throw new RuntimeException(e);
                }
            }
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query) throws CollectorServiceException {
        String nextQuery = "";
        try {
            URL qUrl = new URL(query);
            this.resultStream = qUrl.openStream();
            String resultPage = IOUtils.toString((InputStream)this.resultStream);
            XdmValue nodeList = this.saxonHelper.help().evaluate(resultPage, this.xprEntity);
            log.debug((Object)("nodeList.size: " + nodeList.size()));
            for (XdmItem entity : nodeList) {
                this.recordQueue.add(this.saxonHelper.help().serialize((XdmNode)entity));
            }
            String nextPage = this.saxonHelper.help().evaluateSingleAsString(resultPage, this.xprNextPagePath);
            if (!StringUtils.isBlank((CharSequence)nextPage)) {
                this.queryPage = this.pageParam + "=" + nextPage;
                return this.baseUrl + "?" + this.queryParams + "&" + this.querySize + "&" + this.queryPage;
            }
            log.info((Object)"No next page available, we reached the end");
            if (this.resultTotal == -1) {
                String tot = this.saxonHelper.help().evaluateSingleAsString(resultPage, this.xprResultTotalPath);
                this.resultTotal = Integer.parseInt(tot);
                log.info((Object)("resultTotal was -1 is now: " + this.resultTotal));
            }
            log.info((Object)("resultTotal: " + this.resultTotal));
            log.debug((Object)("nextQueryUrl: " + nextQuery));
            return nextQuery;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalStateException("collection failed: " + e.getMessage());
        }
    }
}

