/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexOnESJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(IndexOnESJobNode.class);
    private String eprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;
    private int nThreads = 5;

    /*
     * Unable to fully structure code
     */
    protected String execute(Env env) throws Exception {
        statusCode = -1;
        indexOnESResult = "noResult";
        IndexOnESJobNode.log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.nThreads);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        IndexOnESJobNode.log.info((Object)("IndexOnES endpoint: " + this.getIndexOnESEndpoint()));
        responsePOST = null;
        try {
            post = new HttpPost(this.getIndexOnESEndpoint());
            params = Lists.newArrayList();
            splits = this.getDatasourceInterface().split("::");
            datasource = splits[2];
            collectionId = splits[3];
            params.add(new BasicNameValuePair("datasource", datasource));
            params.add(new BasicNameValuePair("collectionId", collectionId));
            ent = new UrlEncodedFormEntity((List)params, "UTF-8");
            post.setEntity((HttpEntity)ent);
            IndexOnESJobNode.log.info((Object)("Calling IndexOnES endpoint with params: " + this.getDatasource() + " " + this.getDatasourceInterface()));
            responsePOST = client.execute((HttpUriRequest)post);
            statusCode = responsePOST.getStatusLine().getStatusCode();
            try {
                IndexOnESJobNode.log.info((Object)responsePOST.toString());
                indexOnESResult = responsePOST.getEntity().getContent().toString();
            }
            catch (Exception var13_15) {
                // empty catch block
            }
            switch (statusCode) {
                case 200: {
                    IndexOnESJobNode.log.info((Object)"index on ES completed");
                    ** break;
lbl34:
                    // 1 sources

                    break;
                }
                default: {
                    IndexOnESJobNode.log.error((Object)("error indexing on ES  " + responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
                    break;
                }
            }
        }
        catch (ConnectException ce) {
            IndexOnESJobNode.log.error((Object)ce);
            throw new MSROException("Unable to connect to Publisher endpoint" + this.getIndexOnESEndpoint());
        }
        catch (IOException e) {
            IndexOnESJobNode.log.error((Object)e);
            throw new MSROException("IO Error" + this.getIndexOnESEndpoint());
        }
        finally {
            if (responsePOST != null) {
                responsePOST.close();
            }
            client.close();
            cm.shutdown();
        }
        env.setAttribute("mainlog:statusCode", (Object)Integer.toString(statusCode));
        env.setAttribute("mainlog:indexResult", (Object)indexOnESResult);
        IndexOnESJobNode.log.info((Object)indexOnESResult);
        if (statusCode != 200) {
            throw new MSROException("Error from Publisher endpoint [ status code: " + statusCode + " ]");
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getIndexOnESEndpoint() {
        return this.publisherEndpoint.concat("/indexOnES");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider((ResultSet)token.getEnv().getAttribute(this.getEprParam(), ResultSet.class), this.resultSetClient));
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }
}

