<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>publishing</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
                <PARAM name="cleanMdstoreId"        description="Store for cleaned records"         required="true"     managedBy="system"  category="MDSTORE_ID"     />
				<PARAM name="indexId"               description="Identifier of the Index"           required="true" managedBy="system"  category="INDEX_ID"/>
            	<PARAM name="indexInterpretation"   description="Index Interpretation"              required="true" managedBy="system"  type="string">public</PARAM>
            	<PARAM name="feedingType"           description="Index feeding type"                required="true" managedBy="user"    type="string"   function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
                <PARAM name="publisherEndpoint"     description="AriadnePlus Publisher Endpoint"      required="true" managedBy="user"    type="string">http://localhost:8080/ariadneplus/publish</PARAM>
            </PARAMETERS>
            <WORKFLOW>
                <NODE name="virtuoso" type="LaunchWorkflowTemplate" isStart="true">
                    <DESCRIPTION>Store RDF files in Virtuoso</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="b7a6c826-6d5e-46c7-a553-4c0fc1d9ab72_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="publisherEndpoint"  ref="publisherEndpoint" />
                                <ENTRY key="interface"          value="$interface$" />
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
                <!-- We do not want anymore the public index reading from Virtuoso -->
                <!--
                <NODE name="index" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Index records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="9f1b9aab-d1d5-4ece-a04e-e1157eeb4a11_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsName"             value="$dsName$" />
                                <ENTRY key="interface"          value="$interface$" />
                                <ENTRY key="virtuosoReaderAPIUrl"     ref="virtuosoReaderAPIUrl" />
                                <ENTRY key="indexId"            ref="indexId" />
                                <ENTRY key="feedingType"        ref="feedingType" />
                                <ENTRY key="interpretation"     ref="indexInterpretation" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
                -->
            </WORKFLOW>
            <DESTROY_WORKFLOW_TEMPLATE id="23ef4bb3-2383-45b4-9661-ab03472fcd52_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
                <PARAMETERS/>
            </DESTROY_WORKFLOW_TEMPLATE>
        </CONFIGURATION>

        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
