/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;

public class EnrichGraphDBContentJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(EnrichGraphDBContentJobNode.class);
    private String eprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private String sparqlUpdateQuery;
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;
    private int nThreads = 5;

    /*
     * Unable to fully structure code
     */
    protected String execute(Env env) throws Exception {
        statusCode = -1;
        enrichResult = "noResult";
        EnrichGraphDBContentJobNode.log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        EnrichGraphDBContentJobNode.log.info((Object)("Enrich Query Value: " + this.getSparqlUpdateQuery()));
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.nThreads);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        EnrichGraphDBContentJobNode.log.info((Object)("Enrich endpoint: " + this.getEnrichEndpoint()));
        responsePOST = null;
        try {
            post = new HttpPost(this.getEnrichEndpoint());
            params = Lists.newArrayList();
            datasourceInterfaceValue = this.getDatasourceInterface();
            entity = new StringEntity(this.getSparqlUpdateQuery());
            post.setEntity((HttpEntity)entity);
            responsePOST = client.execute((HttpUriRequest)post);
            statusCode = responsePOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    EnrichGraphDBContentJobNode.log.info((Object)"enrich graphDB content completed");
                    ** break;
lbl22:
                    // 1 sources

                    break;
                }
                default: {
                    EnrichGraphDBContentJobNode.log.error((Object)("error enriching graphDB  " + responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
                    break;
                }
            }
        }
        catch (ConnectException ce) {
            EnrichGraphDBContentJobNode.log.error((Object)ce);
            throw new MSROException("Unable to connect to Publisher endpoint" + this.getEnrichEndpoint());
        }
        catch (IOException e) {
            EnrichGraphDBContentJobNode.log.error((Object)e);
            throw new MSROException("IO Error" + this.getEnrichEndpoint());
        }
        finally {
            if (responsePOST != null) {
                responsePOST.close();
            }
            client.close();
            cm.shutdown();
        }
        env.setAttribute("mainlog:statusCode", (Object)Integer.toString(statusCode));
        env.setAttribute("mainlog:enrichResult", (Object)enrichResult);
        EnrichGraphDBContentJobNode.log.info((Object)enrichResult);
        if (statusCode != 200) {
            throw new MSROException("Error from Publisher endpoint [ status code: " + statusCode + " ]");
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getEnrichEndpoint() {
        return this.publisherEndpoint.concat("/updateSparql");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider((ResultSet)token.getEnv().getAttribute(this.getEprParam(), ResultSet.class), this.resultSetClient));
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getSparqlUpdateQuery() {
        return this.sparqlUpdateQuery;
    }

    public void setSparqlUpdateQuery(String sparqlUpdateQuery) {
        this.sparqlUpdateQuery = sparqlUpdateQuery;
    }
}

