/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.ads;

import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.rmi.data.CollectorServiceRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ADSIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(ADSIterator.class);
    private Iterator<String> iterator;

    public ADSIterator(Iterator<String> recordIterator) {
        this.iterator = recordIterator;
    }

    public boolean doHasNext() {
        return this.iterator.hasNext();
    }

    public String doNext() {
        String record = this.iterator.next();
        try {
            return this.addADSNamespace(record);
        }
        catch (Exception e) {
            log.warn((Object)("Skipping record because of exception " + e));
            log.debug((Object)("Skipped record: " + record));
            if (this.hasNext()) {
                return this.next();
            }
            return "";
        }
    }

    protected String addADSNamespace(String xml) {
        String namespaceList = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n    xmlns:dcterms=\"http://purl.org/dc/terms/\"\n    xmlns:ads=\"https://archaeologydataservice.ac.uk/\"";
        try {
            VTDGen vg = new VTDGen();
            vg.setDoc(xml.getBytes());
            vg.parse(false);
            VTDNav vn = vg.getNav();
            XMLModifier xm = new XMLModifier(vn);
            byte[] attrBytes = namespaceList.getBytes();
            vn.toElement(0);
            xm.insertAttribute(attrBytes);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            xm.output((OutputStream)baos);
            return baos.toString();
        }
        catch (ModifyException | NavException | ParseException | TranscodeException | IOException e) {
            log.error((Object)("Cannot add namespace declarations to element: " + xml));
            throw new CollectorServiceRuntimeException("Cannot add namespace declarations to element", e);
        }
    }

    public Iterator<String> getIterator() {
        return this.iterator;
    }

    public void setIterator(Iterator<String> iterator) {
        this.iterator = iterator;
    }
}

