/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.ads;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import eu.dnetlib.data.collector.plugins.FileCollectorPlugin;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FileJSONCollectorPlugin
extends FileCollectorPlugin {
    private static final Log log = LogFactory.getLog(FileJSONCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        log.info((Object)"FileJSONCollectorPlugin");
        final String metadataRootNodeName = (String)interfaceDescriptor.getParams().get("metadataRootNodeName");
        URL u = null;
        try {
            u = new URL(interfaceDescriptor.getBaseUrl());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            throw new CollectorServiceException((Throwable)e1);
        }
        String baseUrl = u.getPath();
        log.info((Object)("base URL = " + baseUrl));
        try {
            final FileReader fileReader = new FileReader(new File(baseUrl));
            return new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new FileJSONIterator(fileReader, metadataRootNodeName);
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CollectorServiceException((Throwable)e);
        }
    }

    class FileJSONIterator
    implements Iterator<String> {
        private String next;
        private String metadataRootNodeName;
        private Iterator<JsonElement> aatInfosIterator;
        private JsonReader jsonReader;

        public FileJSONIterator(FileReader fileReader, String metadataRootNodeName) {
            this.metadataRootNodeName = metadataRootNodeName;
            this.jsonReader = new JsonReader((Reader)fileReader);
            JsonElement jsonElement = new JsonParser().parse(this.jsonReader);
            JsonArray jsonArrays = jsonElement.getAsJsonArray();
            this.aatInfosIterator = jsonArrays.iterator();
            this.next = this.calculateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String s = this.next;
            this.next = this.calculateNext();
            return s;
        }

        private String calculateNext() {
            try {
                Document document = DocumentHelper.createDocument();
                Element root = document.addElement(this.metadataRootNodeName);
                if (!this.aatInfosIterator.hasNext()) {
                    log.info((Object)"json entries finished, closing RESULT SET");
                    this.jsonReader.close();
                    return null;
                }
                JsonElement aatInfos = this.aatInfosIterator.next();
                JsonObject aatInfoJsonObj = aatInfos.getAsJsonObject();
                Set keys = aatInfoJsonObj.entrySet();
                for (Map.Entry entry : keys) {
                    String value;
                    String key = (String)entry.getKey();
                    JsonElement jsonElement = aatInfoJsonObj.get(key);
                    if (jsonElement.isJsonNull() || StringUtils.isEmpty((CharSequence)(value = jsonElement.getAsString()))) continue;
                    String name = new String(key);
                    Element element = root.addElement(name);
                    value = StringEscapeUtils.escapeXml11((String)value.replace('\r', ' ').replace('\t', ' '));
                    element.addText(value);
                }
                String xmlRecord = new String(document.asXML());
                log.debug((Object)xmlRecord);
                return xmlRecord;
            }
            catch (Exception e) {
                log.error((Object)"Error calculating next json element", (Throwable)e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

