/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IndexOnESJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(IndexOnESJobNode.class);
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;

    protected String execute(Env env) throws Exception {
        int statusCode = -1;
        String response = "";
        log.info((Object)("IndexOnES endpoint: " + this.getIndexOnESEndpoint()));
        CloseableHttpClient client = null;
        try {
            String[] splits = this.getDatasourceInterface().split("::");
            String datasource = splits[2];
            String collectionId = splits[3];
            URI getURI = new URIBuilder(this.getIndexOnESEndpoint()).addParameter("datasource", datasource).addParameter("collectionId", collectionId).build();
            client = HttpClients.createDefault();
            HttpResponse res = client.execute((HttpUriRequest)new HttpGet(getURI));
            response = EntityUtils.toString((HttpEntity)res.getEntity());
            if (res.getStatusLine() != null) {
                statusCode = res.getStatusLine().getStatusCode();
            }
        }
        catch (Throwable t) {
            log.error((Object)t);
            throw new MSROException("Indexing on Elastic Search: " + t.getMessage());
        }
        env.setAttribute("mainlog:statusCode", (Object)Integer.toString(statusCode));
        env.setAttribute("mainlog:response", (Object)response);
        if (statusCode != 200) {
            throw new MSROException("Error from Publisher endpoint [ status code: " + statusCode + " ]");
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getIndexOnESEndpoint() {
        return this.publisherEndpoint.concat("/indexOnES");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }
}

