/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishGraphDBJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(PublishGraphDBJobNode.class);
    private String eprParam;
    @Autowired
    private ResultSetClient resultSetClient;
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;
    private int nThreads = 5;
    private int nTasks = 150;
    private ExecutorService executorService = Executors.newFixedThreadPool(this.nThreads);
    private List<Future<Integer>> resList = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String execute(Env env) throws Exception {
        rsIn = (ResultSet)env.getAttribute(this.getEprParam(), ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("EprParam (" + this.getEprParam() + ") not found in ENV");
        }
        countAll = 0;
        countOk = 0;
        partial = 0;
        errors = Maps.newHashMap();
        PublishGraphDBJobNode.log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.nThreads);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        PublishGraphDBJobNode.log.info((Object)("DropDatasourceApisPartitionInfo endpoint: " + this.getDropDatasourceApisPartitionInfoEndpoint()));
        responseDDAPIPOST = null;
        try {
            post = new HttpPost(this.getDropDatasourceApisPartitionInfoEndpoint());
            params = Lists.newArrayList();
            datasourceInterfaceValue = this.getDatasourceInterface();
            PublishGraphDBJobNode.log.info((Object)("drop datasourceApis partition info for datasourceInterface " + datasourceInterfaceValue));
            params.add((Future<Integer>)new BasicNameValuePair("datasourceApi", datasourceInterfaceValue));
            ent = new UrlEncodedFormEntity(params, "UTF-8");
            post.setEntity((HttpEntity)ent);
            responseDDAPIPOST = client.execute((HttpUriRequest)post);
            statusCode = responseDDAPIPOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    PublishGraphDBJobNode.log.info((Object)"drop datasourceApis partition info completed");
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                default: {
                    PublishGraphDBJobNode.log.error((Object)("error dropping datasourceApis partition info " + statusCode + ": " + responseDDAPIPOST.getStatusLine().getReasonPhrase()));
                    break;
                }
            }
        }
        catch (ConnectException ce) {
            throw new MSROException("unable to connect to Publisher endpoint" + this.getPublishEndpoint());
        }
        catch (IOException e) {
            PublishGraphDBJobNode.log.error((Object)"error feeding provenance ", (Throwable)e);
        }
        finally {
            if (responseDDAPIPOST != null) {
                responseDDAPIPOST.close();
            }
        }
        forceExit = false;
        for (String record : this.getResultSetClient().iter(rsIn, String.class)) {
            if (forceExit) break;
            ++countAll;
            if (partial == this.nTasks) {
                PublishGraphDBJobNode.log.debug((Object)("Waiting for tasks to complete before resubmitting to executor (countAll = " + countAll + ") . . . "));
                PublishGraphDBJobNode.log.debug((Object)"Getting replies");
                startWait = System.currentTimeMillis();
                for (Future<Integer> res : this.resList) {
                    if (res.get() == 200) {
                        ++countOk;
                    }
                    if (res.get() != 400 && res.get() != 401 && !(res.get() == 402 | res.get() == 403) && res.get() != 404) continue;
                    this.executorService.shutdownNow();
                    throw new MSROException("Client error " + res.get());
                }
                this.resList.clear();
                partial = 0;
                PublishGraphDBJobNode.log.debug((Object)(". . . Ready to submit again after " + (System.currentTimeMillis() - startWait) + " ms"));
            }
            ++partial;
            res = this.executorService.submit((Callable<Integer>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute$0(java.lang.String org.apache.http.impl.client.CloseableHttpClient java.util.Map ), ()Ljava/lang/Integer;)((PublishGraphDBJobNode)this, (String)record, (CloseableHttpClient)client, (Map)errors));
            this.resList.add(res);
        }
        this.executorService.shutdown();
        PublishGraphDBJobNode.log.info((Object)"Waiting for responses");
        for (Future<Integer> res : this.resList) {
            if (res.get() != 200) continue;
            ++countOk;
        }
        PublishGraphDBJobNode.log.info((Object)String.format("Got all responses. Ok responses: %s/%s", new Object[]{countOk, countAll}));
        env.setAttribute("mainlog:countOk", (Object)countOk);
        env.setAttribute("mainlog:countAll", (Object)countAll);
        env.setAttribute("mainlog:errorsMap", (Object)new Gson().toJson((Object)errors));
        PublishGraphDBJobNode.log.info((Object)"publishing completed");
        if (!errors.isEmpty()) {
            PublishGraphDBJobNode.log.warn((Object)("Problems in publishing: " + countOk + "/" + countAll + " see error maps for details"));
        }
        if (countAll == 0) {
            PublishGraphDBJobNode.log.warn((Object)"0 resources to publish");
        }
        if (countOk > 0) {
            PublishGraphDBJobNode.log.info((Object)("Feed provenance endpoint: " + this.getProvenanceFeedEndpoint()));
            responsePFPOST = null;
            try {
                post = new HttpPost(this.getProvenanceFeedEndpoint());
                params = Lists.newArrayList();
                datasourceInterfaceValue = this.getDatasourceInterface();
                PublishGraphDBJobNode.log.info((Object)("feeding provenance for datasourceInterface " + datasourceInterfaceValue));
                params.add(new BasicNameValuePair("datasourceApi", datasourceInterfaceValue));
                datasourceValue = this.getDatasource();
                PublishGraphDBJobNode.log.info((Object)("feeding provenance for datasource " + datasourceValue));
                params.add(new BasicNameValuePair("datasource", datasourceValue));
                ent = new UrlEncodedFormEntity((List)params, "UTF-8");
                post.setEntity((HttpEntity)ent);
                responsePFPOST = client.execute((HttpUriRequest)post);
                statusCode = responsePFPOST.getStatusLine().getStatusCode();
                switch (statusCode) {
                    case 200: {
                        PublishGraphDBJobNode.log.info((Object)"feed provenance completed");
                        ** break;
lbl103:
                        // 1 sources

                        break;
                    }
                    default: {
                        PublishGraphDBJobNode.log.error((Object)("error feeding provenance " + responsePFPOST.getStatusLine().getStatusCode() + ": " + responsePFPOST.getStatusLine().getReasonPhrase()));
                        break;
                    }
                }
            }
            catch (ConnectException ce) {
                throw new MSROException("unable to connect to Publisher endpoint" + this.getPublishEndpoint());
            }
            catch (IOException e) {
                PublishGraphDBJobNode.log.error((Object)"error feeding provenance ", (Throwable)e);
            }
            finally {
                if (responsePFPOST != null) {
                    responsePFPOST.close();
                }
                client.close();
                cm.shutdown();
            }
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getPublishEndpoint() {
        return this.publisherEndpoint.concat("/publish");
    }

    private String getProvenanceFeedEndpoint() {
        return this.publisherEndpoint.concat("/feedProvenance");
    }

    private String getDropDatasourceApisPartitionInfoEndpoint() {
        return this.publisherEndpoint.concat("/dropDatasourceApiGraph");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider((ResultSet)token.getEnv().getAttribute(this.getEprParam(), ResultSet.class), this.resultSetClient));
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Integer lambda$execute$0(String record, CloseableHttpClient client, Map errors) throws Exception {
        try (CloseableHttpResponse responsePPOST = null;){
            HttpPost post = new HttpPost(this.getPublishEndpoint());
            ArrayList params = Lists.newArrayList();
            params.add(new BasicNameValuePair("record", record));
            UrlEncodedFormEntity ent = new UrlEncodedFormEntity((List)params, "UTF-8");
            post.setEntity((HttpEntity)ent);
            responsePPOST = client.execute((HttpUriRequest)post);
            int statusCode = responsePPOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    Integer n = statusCode;
                    return n;
                }
            }
            log.error((Object)(responsePPOST.getStatusLine().getStatusCode() + ": " + responsePPOST.getStatusLine().getReasonPhrase()));
            log.error((Object)("Source record causing error: " + record));
            errors.merge(statusCode, 1, Integer::sum);
            Integer n = statusCode;
            return n;
        }
        return -1;
    }
}

