/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ElasticSearchIndexJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ElasticSearchIndexJobNode.class);
    private static final String OAI_NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    private static final String DRI_NAMESPACE_URI = "http://www.driver-repository.eu/namespace/dri";
    private String eprParam;
    private String indexId;
    private String outputEprParam;
    private String mappingPolicyProfileId;
    private boolean verboseLogging;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetClient resultSetClient;
    private String base = "https://www.ariadne-infrastructure.eu/resource/ao/cat/1.1/";
    private static final Model M_MODEL = ModelFactory.createDefaultModel();
    public static final Property has_title = M_MODEL.createProperty("https://www.ariadne-infrastructure.eu/resource/ao/cat/1.1/has_title");
    private OntModel baseModel;
    private static final String BASE_CFG_URL = "http://%s:9200/%s/%s?pretty";
    private String indexHost;
    private String indexName;
    private int readTimeout = 30000;

    protected String execute(Env env) throws Exception {
        this.setup();
        this.setupES();
        ResultSet rsIn = (ResultSet)env.getAttribute(this.eprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.eprParam + ") not found in ENV");
        }
        for (String record : this.getResultSetClient().iter(rsIn, String.class)) {
            String rdfBlock = "";
            try {
                String jsonData = this.prepareJsonData(rdfBlock);
                this.feed(jsonData);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw e;
            }
        }
        log.info((Object)"elastic search indexing completed");
        return Arc.DEFAULT_ARC;
    }

    private void setup() {
        this.baseModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.RDFS_MEM_TRANS_INF);
        this.baseModel.read(this.getInputStream("eu/dnetlib/ariadneplus/rdfs/AO-CAT1.1.1.rdfs"), this.base);
    }

    private String prepareJsonData(String rdfBlock) throws Exception {
        String jsonData = "";
        InfModel model = this.loadBaseModel();
        model.read(IOUtils.toInputStream((String)rdfBlock, (String)"UTF-8"), this.base);
        Resource AO_Individual_Data_Resource = M_MODEL.createResource("https://www.ariadne-infrastructure.eu/resource/ao/cat/1.1/AO_Individual_Data_Resource");
        ResIterator subjects = model.listSubjectsWithProperty(RDF.type, (RDFNode)AO_Individual_Data_Resource);
        while (subjects.hasNext()) {
            Resource subject = subjects.nextResource();
            String title = this.getTitle(subject);
            log.debug((Object)("\n\nRDF TITLE >  " + title));
            jsonData = this.getJsonTitle(title);
            log.debug((Object)("\n\nJSON DATA >  " + jsonData));
        }
        return jsonData;
    }

    private String getTitle(Resource resource) {
        RDFNode obj;
        Statement s = resource.getProperty(has_title);
        if (s != null && (obj = s.getObject()).isLiteral()) {
            return obj.asLiteral().getLexicalForm();
        }
        return this.getLabel(resource);
    }

    private String getLabel(Resource resource) {
        if (resource == null) {
            return "";
        }
        if (resource.hasProperty(RDFS.label)) {
            return resource.getProperty(RDFS.label).getString().replace("'", "'");
        }
        return "";
    }

    private static InputStream getStream(String classpath) throws IOException {
        return new ClassPathResource(classpath).getInputStream();
    }

    protected InfModel loadBaseModel() {
        return ModelFactory.createRDFSModel((Model)this.baseModel);
    }

    private InputStream getInputStream(String classpath) {
        try {
            ClassPathResource resource = new ClassPathResource(classpath);
            return resource.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected String getJsonTitle(String title) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        JsonGenerator jg = jsonFactory.createGenerator((OutputStream)bos, JsonEncoding.UTF8);
        jg.writeStartObject();
        jg.writeStringField("title", title);
        jg.writeEndObject();
        jg.close();
        return out.toString("UTF-8");
    }

    private void setupES() {
        this.indexHost = "localhost";
        this.indexName = "ads-test02";
    }

    private void feed(String record) throws Exception {
        String url = String.format(BASE_CFG_URL, this.indexHost, this.indexName);
        System.out.println("Sending to: " + url);
        System.out.println("record: " + record);
        RestTemplate restTemplate = new RestTemplate(this.getClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)record, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
        if (response.getStatusCode().is2xxSuccessful()) {
            String resolved = (String)response.getBody();
            System.out.println("SUCCESS :" + resolved);
        } else {
            System.out.println("ERROR " + response.getStatusCode());
        }
    }

    private String generateIdentifier(String value, int iteration) {
        int r = ElasticSearchIndexJobNode.getRandomNumberInRange(1, 1000);
        return value.concat("-").concat(Integer.toString(r).concat("-").concat(Integer.toString(iteration)));
    }

    protected ClientHttpRequestFactory getClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setReadTimeout(this.readTimeout);
        return clientHttpRequestFactory;
    }

    private static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.ints(min, max + 1).limit(1L).findFirst().getAsInt();
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getMappingPolicyProfileId() {
        return this.mappingPolicyProfileId;
    }

    public void setMappingPolicyProfileId(String mappingPolicyProfileId) {
        this.mappingPolicyProfileId = mappingPolicyProfileId;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }
}

