/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.base.Splitter;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class EnrichGraphDBContentJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(EnrichGraphDBContentJobNode.class);
    private String sparqlUpdateQuery;
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;
    private int nThreads = 1;

    protected String execute(Env env) throws Exception {
        int statusCode = -1;
        String enrichResult = "";
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.nThreads);
        CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        log.info((Object)("Enrich endpoint: " + this.getEnrichEndpoint()));
        CloseableHttpResponse responsePOST = null;
        String queryValue = this.getSparqlUpdateQuery();
        int countQueries = 0;
        int countSuccess = 0;
        String endpoint = this.getEnrichEndpoint();
        for (String query : Splitter.on((String)";").split((CharSequence)queryValue)) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{query})) continue;
            ++countQueries;
            HttpPost post = new HttpPost(endpoint);
            StringEntity entity = new StringEntity(query);
            post.setEntity((HttpEntity)entity);
            responsePOST = client.execute((HttpUriRequest)post);
            statusCode = responsePOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    log.info((Object)String.format("Query %d executed: %s", countQueries, query));
                    break;
                }
                default: {
                    log.error((Object)("error enriching graphDB  " + responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
                    throw new MSROException(String.format("Cannot execute sparql from %s", query));
                }
            }
            ++countSuccess;
        }
        enrichResult = String.format("Queries committed with success %d/%d", countSuccess, countQueries);
        log.info((Object)enrichResult);
        if (responsePOST != null) {
            responsePOST.close();
        }
        client.close();
        cm.shutdown();
        env.setAttribute("mainlog:enrichResult", (Object)enrichResult);
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getEnrichEndpoint() {
        return this.publisherEndpoint.concat("/updateSparql");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getSparqlUpdateQuery() {
        return this.sparqlUpdateQuery;
    }

    public void setSparqlUpdateQuery(String sparqlUpdateQuery) {
        this.sparqlUpdateQuery = sparqlUpdateQuery;
    }
}

