/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Lists;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

public class ImportPeriodoIntoGraphDBJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(ImportPeriodoIntoGraphDBJobNode.class);
    private String dataUrl;
    private String context;
    private String publisherEndpoint;
    private int nThreads = 5;

    /*
     * Unable to fully structure code
     */
    protected String execute(Env env) throws Exception {
        statusCode = -1;
        loadedResult = "noResult";
        ImportPeriodoIntoGraphDBJobNode.log.info((Object)("Publisher endpoint: " + this.getPublisherEndpoint()));
        ImportPeriodoIntoGraphDBJobNode.log.info((Object)("Context: " + this.getContext()));
        ImportPeriodoIntoGraphDBJobNode.log.info((Object)("Data url: " + this.getDataUrl()));
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.nThreads);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        ImportPeriodoIntoGraphDBJobNode.log.info((Object)("Feed from url endpoint: " + this.getFeedFromUrlEndpoint()));
        responsePOST = null;
        try {
            post = new HttpPost(this.getFeedFromUrlEndpoint());
            params = Lists.newArrayList();
            params.add(new BasicNameValuePair("dataUrl", this.getDataUrl()));
            params.add(new BasicNameValuePair("context", this.getContext()));
            entity = new UrlEncodedFormEntity((List)params, "UTF-8");
            post.setEntity((HttpEntity)entity);
            responsePOST = client.execute((HttpUriRequest)post);
            statusCode = responsePOST.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    ImportPeriodoIntoGraphDBJobNode.log.info((Object)"data loaded completed");
                    loadedResult = "data loaded from url " + this.getDataUrl() + " into context " + this.getContext();
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                default: {
                    ImportPeriodoIntoGraphDBJobNode.log.error((Object)("error loading data into graphDB  " + responsePOST.getStatusLine().getStatusCode() + ": " + responsePOST.getStatusLine().getReasonPhrase()));
                    break;
                }
            }
        }
        catch (ConnectException ce) {
            ImportPeriodoIntoGraphDBJobNode.log.error((Object)ce);
            throw new MSROException("Unable to connect to Publisher endpoint" + this.getFeedFromUrlEndpoint());
        }
        catch (IOException e) {
            ImportPeriodoIntoGraphDBJobNode.log.error((Object)e);
            throw new MSROException("IO error " + this.getFeedFromUrlEndpoint());
        }
        finally {
            if (responsePOST != null) {
                responsePOST.close();
            }
            client.close();
            cm.shutdown();
        }
        env.setAttribute("mainlog:statusCode", (Object)Integer.toString(statusCode));
        env.setAttribute("mainlog:loadedResult", (Object)loadedResult);
        ImportPeriodoIntoGraphDBJobNode.log.info((Object)loadedResult);
        if (statusCode != 200) {
            throw new Exception("Error from Publisher endpoint [ status code: " + statusCode + " ]");
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getFeedFromUrlEndpoint() {
        return this.publisherEndpoint.concat("/feedFromURL");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

