/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class IndexOnESJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(IndexOnESJobNode.class);
    private String publisherEndpoint;
    private String datasourceInterface;
    private String datasource;
    private int currentResourceToIndex = 0;
    private int totalResourceToIndex = 0;

    protected String execute(Env env) throws Exception {
        String collectionResourceType = "COLLECTION";
        String recordResourceType = "RECORD";
        try {
            String[] splits = this.getDatasourceInterface().split("::");
            String datasource = splits[2];
            String collectionId = splits[3];
            log.info((Object)("selecting collection identifiers for " + datasource + " " + collectionId + " ..."));
            List<String> collectionIdentifiers = this.selectIdentifiers(datasource, collectionId, "COLLECTION");
            if (!collectionIdentifiers.isEmpty()) {
                log.info((Object)("retrieved " + collectionIdentifiers.size() + " collections"));
                this.setTotalResourceToIndex(collectionIdentifiers.size());
                int counter = 0;
                List<Integer> counters = Arrays.asList(counter);
                log.info((Object)"start indexing loop for collections ... ");
                collectionIdentifiers.forEach(identifier -> {
                    try {
                        this.indexing(datasource, collectionId, "COLLECTION", this.cleanIdentifier((String)identifier));
                        int value = (Integer)counters.get(0);
                        counters.set(0, value + 1);
                        this.setCurrentResourceToIndex((Integer)counters.get(0));
                    }
                    catch (Throwable t) {
                        log.error((Object)(identifier + " " + t));
                    }
                });
                log.info((Object)"index loop for collections completed");
            }
            log.info((Object)("selecting record identifiers for " + datasource + " " + collectionId + " ..."));
            List<String> recordIdentifiers = this.selectIdentifiers(datasource, collectionId, "RECORD");
            if (!recordIdentifiers.isEmpty()) {
                log.info((Object)("retrieved " + recordIdentifiers.size() + " records"));
                this.setTotalResourceToIndex(recordIdentifiers.size());
                int counter = 0;
                List<Integer> counters = Arrays.asList(counter);
                log.info((Object)"start indexing loop for records ... ");
                recordIdentifiers.forEach(identifier -> {
                    try {
                        this.indexing(datasource, collectionId, "RECORD", this.cleanIdentifier((String)identifier));
                        int value = (Integer)counters.get(0);
                        counters.set(0, value + 1);
                        this.setCurrentResourceToIndex((Integer)counters.get(0));
                    }
                    catch (Throwable t) {
                        log.error((Object)(identifier + " " + t));
                    }
                });
                log.info((Object)"index loop for records completed");
            }
        }
        catch (Throwable t) {
            log.error((Object)t);
            throw new MSROException("Indexing on Elastic Search: " + t.getMessage());
        }
        return Arc.DEFAULT_ARC;
    }

    public String getPublisherEndpoint() {
        return this.publisherEndpoint;
    }

    private String getIndexOnESEndpoint() {
        return this.publisherEndpoint.concat("/indexOnESByIdentifier");
    }

    private String getSelectIdentifiersEndpoint() {
        return this.publisherEndpoint.concat("/selectIdentifiers");
    }

    public void setPublisherEndpoint(String publisherEndpoint) {
        this.publisherEndpoint = publisherEndpoint;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    private String cleanIdentifier(String identifier) {
        String cleaned = identifier;
        try {
            cleaned = identifier.replace("[", "").replace("]", "").replace("\"", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cleaned;
    }

    private String indexing(String datasource, String collectionId, String resourceType, String identifier) throws IOException, URISyntaxException {
        int statusCode = -1;
        String response = "";
        String result = "";
        String endpoint = this.getIndexOnESEndpoint();
        CloseableHttpClient client = null;
        URI postURI = new URIBuilder(endpoint).addParameter("datasource", datasource).addParameter("collectionId", collectionId).addParameter("resourceType", resourceType).addParameter("identifier", identifier).build();
        client = HttpClients.createDefault();
        HttpResponse res = client.execute((HttpUriRequest)new HttpPost(postURI));
        if (res.getStatusLine() != null) {
            statusCode = res.getStatusLine().getStatusCode();
        }
        HttpEntity entity = res.getEntity();
        result = EntityUtils.toString((HttpEntity)entity);
        return result;
    }

    private List<String> selectIdentifiers(String datasource, String collectionId, String resourceType) throws Exception {
        int statusCode = -1;
        String response = "";
        List<String> identifiers = null;
        String endpoint = this.getSelectIdentifiersEndpoint();
        CloseableHttpClient client = null;
        URI getURI = new URIBuilder(endpoint).addParameter("datasource", datasource).addParameter("collectionId", collectionId).addParameter("resourceType", resourceType).build();
        client = HttpClients.createDefault();
        HttpResponse res = client.execute((HttpUriRequest)new HttpGet(getURI));
        if (res.getStatusLine() != null) {
            statusCode = res.getStatusLine().getStatusCode();
        }
        HttpEntity entity = res.getEntity();
        String content = EntityUtils.toString((HttpEntity)entity);
        String[] identifiersStr = content.split(",");
        identifiers = Arrays.asList(identifiersStr);
        return identifiers;
    }

    protected void beforeStart(Token token) {
        token.setProgressProvider(new ProgressProvider(){

            public String getProgressDescription() {
                return IndexOnESJobNode.this.currentResourceToIndex + " / " + IndexOnESJobNode.this.totalResourceToIndex;
            }
        });
    }

    public int getCurrentResourceToIndex() {
        return this.currentResourceToIndex;
    }

    public void setCurrentResourceToIndex(int currentResourceToIndex) {
        this.currentResourceToIndex = currentResourceToIndex;
    }

    public int getTotalResourceToIndex() {
        return this.totalResourceToIndex;
    }

    public void setTotalResourceToIndex(int totalResourceToIndex) {
        this.totalResourceToIndex = totalResourceToIndex;
    }
}

