/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.ariadneplus.workflows.nodes;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.xml.SaxonHelper;
import eu.dnetlib.miscutils.functional.xml.XMLIndenter;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.nodes.transform.ApplyX3Mapping;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class X3MTransformAriadnePlusJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(X3MTransformAriadnePlusJobNode.class);
    private static final String OAI_NAMESPACE_URI = "http://www.openarchives.org/OAI/2.0/";
    private static final String DRI_NAMESPACE_URI = "http://www.driver-repository.eu/namespace/dri";
    private String inputEprParam;
    private String outputEprParam;
    private String mappingPolicyProfileId;
    private String mappingUrl;
    private boolean verboseLogging;
    private XPathSelector xpathSelectorMetadata;
    private XPathSelector xpathSelectorHeader;
    private XPathSelector xpathSelectorFooter;
    private XPathSelector xpathSelectorObjIdentifier;
    private boolean passFullRecord;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private SaxonHelper saxonHelper;

    protected String execute(Env env) throws Exception {
        log.info((Object)("Mapping Policy profile id read from node configuration: " + this.mappingPolicyProfileId));
        log.info((Object)("Mapping url read from node configuration: " + this.mappingUrl));
        URL mappingURL = new URL(this.mappingUrl);
        String policy = this.getProfileCode(this.mappingPolicyProfileId);
        LocalDateTime now = LocalDateTime.now();
        ResultSet rsIn = (ResultSet)env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        this.prepareXpathSelectors();
        ResultSet rsOut = this.resultSetFactory.map(rsIn, String.class, record -> {
            if (log.isDebugEnabled()) {
                String objIdentifier = this.extractFromRecord((String)record, this.xpathSelectorObjIdentifier);
                log.debug((Object)("Transforming record objIdentifier: " + objIdentifier));
            }
            ApplyX3Mapping mappingFunction = new ApplyX3Mapping(mappingURL, policy, this.verboseLogging);
            String toTransform = record;
            Instant startExtraction = Instant.now();
            if (!this.isPassFullRecord()) {
                log.debug((Object)"Extracting XML from the metadata block");
                toTransform = this.extractFromRecord((String)record, this.xpathSelectorMetadata);
            }
            String header = this.extractFromRecord((String)record, this.xpathSelectorHeader);
            String provenanceFooter = this.extractFromRecord((String)record, this.xpathSelectorFooter);
            Instant endExtraction = Instant.now();
            Instant startTransform = Instant.now();
            String transformed = mappingFunction.apply(toTransform);
            Instant endTransform = Instant.now();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Extraction took " + Duration.between(startExtraction, endExtraction).toMillis() + " ms"));
                log.debug((Object)("Transformation took " + Duration.between(startTransform, endTransform).toMillis() + " ms"));
                log.debug((Object)("Total mapping time: " + Duration.between(startExtraction, endTransform).toMillis() + " ms"));
            }
            String res = this.buildXML(header, now.toString(), transformed, provenanceFooter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SOURCE:\n" + toTransform));
                log.debug((Object)("TRANFORMED:\n" + res));
            }
            return res;
        });
        env.setAttribute(this.outputEprParam, (Object)rsOut);
        return Arc.DEFAULT_ARC;
    }

    private String[] getMappingsCode(String[] mappingIds) throws ISLookUpException {
        String[] mappings = new String[mappingIds.length];
        for (int i = 0; i < mappingIds.length; ++i) {
            mappings[i] = this.getProfileCode(mappingIds[i]);
        }
        return mappings;
    }

    protected String buildXML(String header, String transformationDate, String metadata, String provenance) {
        Instant start = Instant.now();
        try {
            XMLIndenter xmlHelper = new XMLIndenter();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElementNS(OAI_NAMESPACE_URI, "oai:record");
            Element headerElem = docBuilder.parse(IOUtils.toInputStream((String)header, (String)"UTF-8")).getDocumentElement();
            Node headerNode = doc.importNode(headerElem, true);
            rootElement.appendChild(headerNode);
            Element transDate = doc.createElementNS(DRI_NAMESPACE_URI, "dri:dateOfTransformation");
            transDate.setTextContent(transformationDate);
            headerNode.appendChild(transDate);
            Element metadataElement = doc.createElementNS(OAI_NAMESPACE_URI, "oai:metadata");
            Element contentElem = docBuilder.parse(IOUtils.toInputStream((String)metadata, (String)"UTF-8")).getDocumentElement();
            Node contentNode = doc.importNode(contentElem, true);
            metadataElement.appendChild(contentNode);
            rootElement.appendChild(metadataElement);
            Element aboutElem = docBuilder.parse(IOUtils.toInputStream((String)provenance, (String)"UTF-8")).getDocumentElement();
            Node aboutNode = doc.importNode(aboutElem, true);
            rootElement.appendChild(aboutNode);
            doc.appendChild(rootElement);
            Instant startIndent = Instant.now();
            String res = xmlHelper.indent(doc);
            Instant end = Instant.now();
            if (log.isDebugEnabled()) {
                log.debug((Object)("XML built in " + Duration.between(start, end).toMillis() + " ms"));
                log.debug((Object)("Serialization with indent took " + Duration.between(startIndent, end).toMillis() + " ms"));
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build the transformed xml file", e);
        }
    }

    private void prepareXpathSelectors() throws SaxonApiException {
        HashMap namespaces = Maps.newHashMap();
        namespaces.put("oai", OAI_NAMESPACE_URI);
        namespaces.put("dri", DRI_NAMESPACE_URI);
        this.xpathSelectorHeader = this.saxonHelper.help().prepareXPathSelector("//oai:header", (Map)namespaces);
        this.xpathSelectorMetadata = this.saxonHelper.help().prepareXPathSelector("//oai:metadata/*", (Map)namespaces);
        this.xpathSelectorFooter = this.saxonHelper.help().prepareXPathSelector("//oai:about", (Map)namespaces);
        this.xpathSelectorObjIdentifier = this.saxonHelper.help().prepareXPathSelector("//oai:header/*[local-name()='objIdentifier']/text()", (Map)namespaces);
    }

    private String extractFromRecord(String record, XPathSelector xPathSelector) {
        try {
            return this.saxonHelper.help().setSerializerProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes").evaluateSingleAsString(record, xPathSelector);
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Cannot extract content ", e);
        }
    }

    private String getProfileCode(String profId) throws ISLookUpException {
        if (StringUtils.isBlank((CharSequence)profId)) {
            return null;
        }
        String xquery = "string(collection('/db/DRIVER/TransformationRuleDSResources')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + profId + "']//CODE)";
        List res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        if (res.isEmpty() || StringUtils.isBlank((CharSequence)((CharSequence)res.get(0)))) {
            throw new RuntimeException("Can't find transformation rule CODE for " + profId);
        }
        return (String)res.get(0);
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getMappingPolicyProfileId() {
        return this.mappingPolicyProfileId;
    }

    public void setMappingPolicyProfileId(String mappingPolicyProfileId) {
        this.mappingPolicyProfileId = mappingPolicyProfileId;
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public boolean isPassFullRecord() {
        return this.passFullRecord;
    }

    public void setPassFullRecord(boolean passFullRecord) {
        this.passFullRecord = passFullRecord;
    }

    public String getMappingUrl() {
        return this.mappingUrl;
    }

    public void setMappingUrl(String mappingUrl) {
        this.mappingUrl = mappingUrl;
    }

    private String[] getMappingsFromUrl(String url) {
        String[] mappings = new String[1];
        return mappings;
    }
}

