/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.ads;

import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.FileCollectorPlugin;
import eu.dnetlib.data.collector.plugins.ariadneplus.ads.ADSIterable;
import eu.dnetlib.data.collector.plugins.ariadneplus.ads.ADSIterator;
import eu.dnetlib.data.collector.plugins.filesystem.FileSystemIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.HttpConnector;
import eu.dnetlib.miscutils.iterators.xml.XMLIterator;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ADSCollectorPlugin
extends FileCollectorPlugin {
    private Iterator<String> recordIterator;
    @Autowired
    private HttpConnector httpConnector;
    private static final Log log = LogFactory.getLog(ADSCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        String srf = (String)interfaceDescriptor.getParams().get("singleRemoteFile");
        boolean singleRemoteFile = Boolean.valueOf(srf);
        log.debug((Object)("bool singleRemoteFile? " + singleRemoteFile));
        if (!singleRemoteFile) {
            URL basePath;
            String url = baseUrl.startsWith("file://") ? baseUrl : "file://".concat(baseUrl);
            try {
                basePath = new URL(url);
            }
            catch (MalformedURLException mue) {
                log.error((Object)("Failed collecting from base url " + url), (Throwable)mue);
                throw new CollectorServiceException((Throwable)mue);
            }
            File baseDir = new File(basePath.getPath());
            if (!baseDir.exists()) {
                throw new CollectorServiceException(String.format("The base URL %s, does not exist", basePath.getPath()));
            }
            log.debug((Object)("Start collecting from folder " + baseDir + " ..."));
            FileSystemIterator fsi = new FileSystemIterator(baseDir.getAbsolutePath(), "xml");
            boolean emptyIterator = true;
            while (fsi.hasNext()) {
                String nextFilePath = fsi.next();
                interfaceDescriptor.setBaseUrl("file://".concat(nextFilePath));
                try {
                    log.debug((Object)("Add iterator from " + nextFilePath));
                    if (emptyIterator) {
                        this.recordIterator = new ADSIterator(super.collect(interfaceDescriptor, fromDate, untilDate).iterator());
                        emptyIterator = false;
                        continue;
                    }
                    this.recordIterator = Iterators.concat(this.recordIterator, (Iterator)((Object)new ADSIterator(super.collect(interfaceDescriptor, fromDate, untilDate).iterator())));
                }
                catch (CollectorServiceException e) {
                    log.error((Object)("Failed collecting from path: " + nextFilePath), (Throwable)e);
                }
            }
            return new ADSIterable(this.recordIterator);
        }
        return this.collectFromSingleRemoteFile(baseUrl, (String)interfaceDescriptor.getParams().get("splitOnElement"));
    }

    public Iterable<String> collectFromSingleRemoteFile(String baseUrl, String splitOnElement) throws CollectorServiceException {
        String xml = this.httpConnector.getInputSource(baseUrl);
        BufferedInputStream bis = new BufferedInputStream(IOUtils.toInputStream((String)xml, (Charset)Charset.forName("utf-8")));
        return new ADSIterable((Iterator<String>)((Object)new ADSIterator((Iterator<String>)new XMLIterator(splitOnElement, (InputStream)bis))));
    }

    public Iterator<String> getRecordIterator() {
        return this.recordIterator;
    }

    public void setRecordIterator(Iterator<String> recordIterator) {
        this.recordIterator = recordIterator;
    }

    public HttpConnector getHttpConnector() {
        return this.httpConnector;
    }

    public void setHttpConnector(HttpConnector httpConnector) {
        this.httpConnector = httpConnector;
    }
}

