/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ariadneplus.ads;

import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.ariadneplus.ads.ADSIterable;
import eu.dnetlib.data.collector.plugins.ariadneplus.ads.FileJSONCollectorPlugin;
import eu.dnetlib.data.collector.plugins.filesystem.FileSystemIterator;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderCollectorPlugin
extends FileJSONCollectorPlugin {
    private Iterator<String> recordIterator;
    private URL basePath;
    private static final Log log = LogFactory.getLog(FolderCollectorPlugin.class);

    @Override
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        String url = "file://".concat(baseUrl);
        try {
            this.basePath = new URL(url);
        }
        catch (MalformedURLException mue) {
            log.error((Object)("Failed collecting json from base url " + url), (Throwable)mue);
            throw new CollectorServiceException((Throwable)mue);
        }
        File baseDir = new File(this.basePath.getPath());
        if (!baseDir.exists()) {
            throw new CollectorServiceException(String.format("The base ULR %s, does not exist", this.basePath.getPath()));
        }
        log.debug((Object)("Start collecting json from folder " + baseDir + " ..."));
        FileSystemIterator fsi = new FileSystemIterator(baseDir.getAbsolutePath(), "json");
        boolean emptyIterator = true;
        while (fsi.hasNext()) {
            String nextFilePath = fsi.next();
            interfaceDescriptor.setBaseUrl("file://".concat(nextFilePath));
            try {
                log.debug((Object)("Add iterator from " + nextFilePath));
                if (emptyIterator) {
                    this.recordIterator = super.collect(interfaceDescriptor, fromDate, untilDate).iterator();
                    emptyIterator = false;
                    continue;
                }
                this.recordIterator = Iterators.concat(this.recordIterator, super.collect(interfaceDescriptor, fromDate, untilDate).iterator());
            }
            catch (CollectorServiceException e) {
                log.error((Object)("Failed collecting json from path: " + nextFilePath), (Throwable)e);
            }
        }
        return new ADSIterable(this.recordIterator);
    }
}

