<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>aggregator</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
				<PARAM name="transformationRuleId"  description="Transformation Rule Identifier"            required="true" managedBy="user"    category="TRANSFORMATION_RULE_ID" type="string" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')"/>
            	<PARAM name="collMdstoreId"         description="Store for collected records"               required="true" managedBy="system"  category="MDSTORE_ID"/>
            	<PARAM name="cleanMdstoreId"        description="Store for cleaned records"                 required="true" managedBy="system"  category="MDSTORE_ID"/>
            	<PARAM name="indexId"               description="Identifier of the Index"                   required="true" managedBy="system"  category="INDEX_ID"/>
            	<PARAM name="feedingType"           description="Index feeding type"                        required="true" managedBy="user"    type="string"   function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
            	<PARAM name="OAIFormat"             description="OAI Format"                                required="true" managedBy="system"  type="string">PMF</PARAM>
                <PARAM name="OAILayout"             description="OAI Layout"                                required="true" managedBy="system"  type="string">OAI</PARAM>
                <PARAM name="OAIInterpretation"     description="OAI Interpretation"                        required="true" managedBy="system"  type="string">cleaned</PARAM>
                <PARAM name="OAIDBName"             description="OAI Database Name"                         required="true" managedBy="system"  type="string">oaistore_dnet</PARAM>
                <PARAM name="OAIConfiguredOnly"     description="Count only configured OAI sets"            required="true" managedBy="system" type="boolean">false</PARAM>
            </PARAMETERS>
            <WORKFLOW>
                <NODE isStart="true" name="collection" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Collect records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="wfTemplateId" value="c7bb1054-2a4c-4966-b540-39ce1982abe5_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"          value="$dsId$" />
 								<ENTRY key="interface"     value="$interface$" />
	 							<ENTRY key="collMdstoreId" ref="collMdstoreId" />
                    		</MAP>
                    	</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="transform"/>
                    </ARCS>
                </NODE>
                <NODE name="transform" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Transform record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="76db1a00-958d-4fa8-82c7-6fd2010f781d_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"            value="$dsId$" />
                                <ENTRY key="interface"       value="$interface$" />
                                <ENTRY key="collMdstoreId"   ref="collMdstoreId" />
                                <ENTRY key="cleanMdstoreId"  ref="cleanMdstoreId" />
                                <ENTRY key="transformRuleId" ref="transformationRuleId" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="index"/>
                       <!-- <ARC to="oaiFeed"/> -->
                    </ARCS>
                </NODE>
                <NODE name="index" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Index record</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="1ee9dfb8-cbd1-4305-be76-5fc512ff5eb1_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                                <ENTRY key="dsId"               value="$dsId$" />
                                <ENTRY key="interface"          value="$interface$" />
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                                <ENTRY key="indexId"            ref="indexId" />
                                <ENTRY key="feedingType"        ref="feedingType" />
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oaiFeed"/>
                    </ARCS>
                </NODE>
                <NODE name="oaiFeed" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Feed oai records</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="696fc66f-726e-4d90-aa6a-e83a5815a605_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                               <!-- <ENTRY key="dsId"               value="$dsId$" /> -->
                                <ENTRY key="cleanMdstoreId"     ref="cleanMdstoreId" />
                                <ENTRY key="OAIFormat"          ref="OAIFormat"/>
                                <ENTRY key="OAILayout"          ref="OAILayout"/>
                                <ENTRY key="OAIInterpretation"  ref="OAIInterpretation"/>
                                <ENTRY key="OAIDBName"          ref="OAIDBName"/>
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="oaiPostFeed"/>
                    </ARCS>
                </NODE>
                <NODE name="oaiPostFeed" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Oai Post Feed Action</DESCRIPTION>
                    <PARAMETERS>
                        <PARAM name="wfTemplateId" value="049a45f1-ba94-4b5b-9377-1c695b622fd8_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                        <PARAM name="wfTemplateParams">
                            <MAP>
                               <ENTRY key="dsId"               value="$dsId$" />
                               <ENTRY key="OAIFormat"          ref="OAIFormat"/>
                               <ENTRY key="OAILayout"          ref="OAILayout"/>
                               <ENTRY key="OAIInterpretation"  ref="OAIInterpretation"/>
                               <ENTRY key="OAIDBName"          ref="OAIDBName"/>
                               <ENTRY key="OAIConfiguredOnly"  ref="OAIConfiguredOnly"/>
                            </MAP>
                        </PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
            </WORKFLOW>
            <DESTROY_WORKFLOW_TEMPLATE id="b54ff264-ed25-46a5-86df-dfbefb0b22be_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==">
            	<PARAMETERS>
	            	<PARAM name="dsId"                  value="$dsId$" />
	            	<!--<PARAM name="dsName"                value="$dsName$" />-->
					<PARAM name="interface"             value="$interface$" />
					<PARAM name="collMdstoreId"         ref="collMdstoreId" />
					<PARAM name="cleanMdstoreId"        ref="cleanMdstoreId" />
					<PARAM name="indexId"               ref="indexId" />
					<PARAM name="OAIDBName"             ref="OAIDBName"/>
                    <PARAM name="OAIFormat"             ref="OAIFormat"/>
                    <PARAM name="OAILayout"             ref="OAILayout"/>
                    <PARAM name="OAIInterpretation"     ref="OAIInterpretation"/>
				</PARAMETERS>
            </DESTROY_WORKFLOW_TEMPLATE>
        </CONFIGURATION>

        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
