<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0"
>

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<div class="row">
			<div class="col-xs-2">
				<img src="../resources/img/record.png" width="80" height="80"/>
			</div>
			<div class="col-xs-10">
				<xsl:if test="//*[local-name()='title']">
					<h1 id="overview">
						<xsl:value-of select="//*[local-name()='title']"/>
					</h1>
				</xsl:if>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<h6>
					<span class="glyphicon glyphicon-align-left"/>
					GENERAL INFORMATION
				</h6>
				<table class="table">
					<tbody>
						<tr>
							<td class="col-xs-3">
								<strong>Author</strong>
							</td>
							<td>
								<xsl:for-each select="//*[local-name()='creator']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Title</strong>
							</td>
							<td>
								<xsl:for-each select="//*[local-name()='title']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Description</strong>
							</td>
							<td>
								<xsl:for-each select="//*[local-name()='description']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Identifier</strong>
							</td>
							<td>
								<xsl:for-each select="//*[local-name()='identifier']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
						<tr>
							<td class="col-xs-3">
								<strong>Type</strong>
							</td>
							<td>
								<xsl:for-each select="//*[local-name()='type']">
									<xsl:value-of select="."/>
									<br/>
								</xsl:for-each>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>

		<xsl:for-each select="//*[local-name()='record']">
			<h6>
				<span class="glyphicon glyphicon-wrench"/>
				RECORD XML
			</h6>
			<xsl:call-template name="xmlItem">
				<xsl:with-param name="indent" select="string('')"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="xmlItem">
		<xsl:param name="indent"/>

		<xsl:variable name="tag" select="local-name()"/>

		<xsl:variable name="newindent">
			<xsl:value-of select="$indent"/>
			&#160;&#160;&#160;&#160;
		</xsl:variable>

		<xsl:variable name="attribs">
			<xsl:for-each select="@*">
				<xsl:value-of select="concat(' ', local-name(), '=&quot;', ., '&quot;')"/>
			</xsl:for-each>
		</xsl:variable>
		<xsl:value-of select="$indent"/>

		<b>
			<xsl:value-of select="concat('&lt;',$tag)"/>
		</b>
		<i>
			<xsl:value-of select="$attribs"/>
		</i>
		<b>&gt;</b>

		<xsl:value-of select="text()"/>

		<xsl:choose>
			<xsl:when test="count(child::*) &gt; 0">
				<br/>
				<xsl:for-each select="child::*">
					<xsl:call-template name="xmlItem">
						<xsl:with-param name="indent" select="$newindent"/>
					</xsl:call-template>
					<br/>
				</xsl:for-each>
				<xsl:value-of select="$indent"/>
			</xsl:when>
			<xsl:otherwise>

			</xsl:otherwise>
		</xsl:choose>

		<b>
			<xsl:value-of select="concat('&lt;/',$tag,'&gt;')"/>
		</b>

	</xsl:template>

	<xsl:template name="threedimensions">
		<xsl:param name="w"/>
		<xsl:param name="h"/>
		<xsl:param name="d"/>
		<xsl:param name="unit"/>

		<xsl:variable name="actualW">
			<xsl:choose>
				<xsl:when test="normalize-space($w) != ''">
					<xsl:value-of select="normalize-space($w)"/>
				</xsl:when>
				<xsl:otherwise>??</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="actualH">
			<xsl:choose>
				<xsl:when test="normalize-space($h) != ''">
					<xsl:value-of select="normalize-space($h)"/>
				</xsl:when>
				<xsl:otherwise>??</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="actualD">
			<xsl:choose>
				<xsl:when test="normalize-space($d) != ''">
					<xsl:value-of select="normalize-space($d)"/>
				</xsl:when>
				<xsl:otherwise>??</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:value-of select="concat($actualW,' x ', $actualH,' x ', $actualD, ' (', $unit, ')')"/>
	</xsl:template>

	<xsl:template name="twodimensions">
		<xsl:param name="w"/>
		<xsl:param name="h"/>
		<xsl:param name="d"/>
		<xsl:param name="unit"/>

		<xsl:variable name="actualW">
			<xsl:choose>
				<xsl:when test="normalize-space($w) != ''">
					<xsl:value-of select="normalize-space($w)"/>
				</xsl:when>
				<xsl:otherwise>??</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="actualH">
			<xsl:choose>
				<xsl:when test="normalize-space($h) != ''">
					<xsl:value-of select="normalize-space($h)"/>
				</xsl:when>
				<xsl:otherwise>??</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:value-of select="concat($actualW,' x ', $actualH, ' (', $unit, ')')"/>
	</xsl:template>

</xsl:stylesheet>
