<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="2.0"
>

	<xsl:output method="html" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>

	<xsl:template match="/">
		<xsl:for-each select="//field">
			<xsl:variable name="field" select="@name"/>
			<xsl:variable name="label" select="@label"/>
			<div class="panel-group" id="accordion_{$field}">
				<div class="panel panel-default">
					<div class="panel-heading">
						<h4 class="panel-title">
							<a href="javascript:void(0)" ng-click="browse_one('{$field}', '{$label}')" data-toggle="modal" data-target="#browseOneModal">
								<xsl:value-of select="$label"/>
							</a>
							<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion_{$field}" data-target="#collapse_{$field}"/>
						</h4>
					</div>
					<div id="collapse_{$field}" class="panel-collapse collapse in">
						<table class="table" ng-hide="browse_{$field}_showAll">
							<xsl:for-each select="./value">
								<tr>
									<td>
										<a href="javascript:void(0)" ng-click="updateQueryWithValue('{$field}', '{@name}', 0)">
											<xsl:value-of select="@name"/>
										</a>
									</td>
									<td class="text-right">
										<xsl:value-of select="@size"/>
									</td>
								</tr>
							</xsl:for-each>
						</table>
					</div>
				</div>
			</div>
		</xsl:for-each>

	</xsl:template>
</xsl:stylesheet>