/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtils {
    private static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    private static final SimpleDateFormat OUTFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'", Locale.US);
    private static final List<String> INPUTFORMATS = Arrays.asList("yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy");
    private final transient Date date;

    public DateUtils() {
        this.date = new Date();
    }

    public DateUtils(Date date) {
        this.date = (Date)date.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDateAsISO8601String() {
        String result;
        SimpleDateFormat simpleDateFormat = ISO8601FORMAT;
        synchronized (simpleDateFormat) {
            result = ISO8601FORMAT.format(this.date);
        }
        return result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
    }

    public Long getPrecisionTime() {
        return this.date.getTime();
    }

    public static long now() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String now_ISO8601() {
        String result;
        SimpleDateFormat simpleDateFormat = ISO8601FORMAT;
        synchronized (simpleDateFormat) {
            result = ISO8601FORMAT.format(new Date());
        }
        return result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String dateArg) {
        String date = dateArg;
        if ("".equals(date)) {
            return null;
        }
        try {
            Object end;
            if (date.endsWith("Z")) {
                date = date.replace("Z", "+0000");
            } else if (date.length() < 20) {
                date = date + "+0000";
            } else {
                end = date.substring(date.length() - 3);
                date = date.substring(0, date.length() - 3) + ((String)end).replace(":", "");
            }
            end = ISO8601FORMAT;
            synchronized (end) {
                return ISO8601FORMAT.parse(date);
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid iso8601 date '" + dateArg + "' (even after normalizing it to '" + date + "')");
        }
    }

    public static String calculate_ISO8601(long l) {
        String result = ISO8601FORMAT.format(new Date(l));
        result = result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
        return result;
    }

    public String getDuration(String dateArg) {
        String[] splitted = dateArg.split("T");
        if (splitted.length == 1) {
            return "0";
        }
        return splitted[1];
    }

    public static String getParsedDateField(String date) {
        for (String formatString : INPUTFORMATS) {
            try {
                return OUTFORMAT.format(new SimpleDateFormat(formatString).parse(date));
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("unable to parse date: " + date);
    }
}

