package eu.dnetlib.utils;

public class MetadataReferenceFactory {

	public MetadataReference getMetadata(final String format, final String layout, final String interpretation) {
		return new MetadataReference(format, layout, interpretation);
	}

	public MetadataReference decodeMetadata(final String encoded) {
		return decodeMetadata(encoded, "@");
	}

	public MetadataReference decodeMetadata(final String encoded, final String separator) {
		String[] split = encoded.split(separator);
		if (split.length == 3) return getMetadata(split[0], split[1], split[2]);

		throw new IllegalStateException("malformed metadata reference: " + encoded);
	}

	public static MetadataReference decode(final String encoded, final String separator) {
		return new MetadataReferenceFactory().decodeMetadata(encoded, separator);
	}

}
