/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ValueFormatHelper {
    public static final ValueFormatHelper INSTANCE = new ValueFormatHelper();
    private static final int DATE_LENGTH = 10;
    private static final int DATE_TIME_LENGTH_PATTERN_DEFAULT = 28;
    private static final int DATE_TIME_LENGTH_PATTERN_2_AND_3 = 24;
    private static final int DATE_TIME_LENGTH_PATTERN_4 = 20;
    private final DateFormat _formatDate = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat _formatDateTimePatternDefault = ValueFormatHelper.getDefaultDateTimeFormat();
    private final DateFormat _formatDateTimePattern2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final DateFormat _formatDateTimePattern3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final DateFormat _formatDateTimePattern4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Pattern _formatPatternDateDefault = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
    private final Pattern _formatPatternTimeDefault = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]{1}\\d{4}");
    private final Pattern _formatPatternTime2 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}[+-]{1}\\d{4}");
    private final Pattern _formatPatternTime3 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z");
    private final Pattern _formatPatternTime4 = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");

    public ValueFormatHelper() {
        this._formatDate.setLenient(false);
        this._formatDateTimePatternDefault.setLenient(false);
        this._formatDateTimePattern2.setLenient(false);
        this._formatDateTimePattern3.setLenient(false);
        this._formatDateTimePattern3.setTimeZone(TimeZone.getTimeZone("UTC"));
        this._formatDateTimePattern4.setLenient(false);
        this._formatDateTimePattern4.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static SimpleDateFormat getDefaultDateTimeFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        sdf.setLenient(false);
        return sdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDate(Date value) {
        DateFormat dateFormat = this._formatDate;
        synchronized (dateFormat) {
            return this._formatDate.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatDateTime(Date value) {
        DateFormat dateFormat = this._formatDateTimePatternDefault;
        synchronized (dateFormat) {
            return this._formatDateTimePatternDefault.format(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDate(String dateString) throws ParseException {
        if (dateString.length() == 10 && this._formatPatternDateDefault.matcher(dateString).matches()) {
            DateFormat dateFormat = this._formatDate;
            synchronized (dateFormat) {
                return this._formatDate.parse(dateString);
            }
        }
        throw new ParseException("Length of date string '" + dateString + "' exceeds maximum date length of " + 10, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date tryParseDate(String dateString) {
        if (dateString.length() == 10 && this._formatPatternDateDefault.matcher(dateString).matches()) {
            DateFormat dateFormat = this._formatDate;
            synchronized (dateFormat) {
                try {
                    return this._formatDate.parse(dateString);
                }
                catch (ParseException parseException) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseDateTime(String dateTimeString) throws ParseException {
        Date result;
        int dateLen = dateTimeString.length();
        if (dateLen == 28 && this._formatPatternTimeDefault.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePatternDefault;
            synchronized (dateFormat) {
                result = this._formatDateTimePatternDefault.parse(dateTimeString);
            }
        } else if (dateLen == 24 && this._formatPatternTime2.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern2;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern2.parse(dateTimeString);
            }
        } else if (dateLen == 24 && this._formatPatternTime3.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern3;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern3.parse(dateTimeString);
            }
        } else if (dateLen == 20 && this._formatPatternTime4.matcher(dateTimeString).matches()) {
            DateFormat dateFormat = this._formatDateTimePattern4;
            synchronized (dateFormat) {
                result = this._formatDateTimePattern4.parse(dateTimeString);
            }
        } else {
            throw new ParseException("Length '" + dateTimeString.length() + "' of datetime string '" + dateTimeString + "' doesn't match expected pattern length", dateTimeString.length());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date tryParseDateTime(String dateTimeString) {
        Date result = null;
        try {
            switch (dateTimeString.length()) {
                case 28: {
                    if (!this._formatPatternTimeDefault.matcher(dateTimeString).matches()) break;
                    DateFormat dateFormat = this._formatDateTimePatternDefault;
                    synchronized (dateFormat) {
                        result = this._formatDateTimePatternDefault.parse(dateTimeString);
                        break;
                    }
                }
                case 24: {
                    if (this._formatPatternTime2.matcher(dateTimeString).matches()) {
                        DateFormat dateFormat = this._formatDateTimePattern2;
                        synchronized (dateFormat) {
                            result = this._formatDateTimePattern2.parse(dateTimeString);
                            break;
                        }
                    }
                    if (!this._formatPatternTime3.matcher(dateTimeString).matches()) break;
                    DateFormat dateFormat = this._formatDateTimePattern3;
                    synchronized (dateFormat) {
                        result = this._formatDateTimePattern3.parse(dateTimeString);
                        break;
                    }
                }
                case 20: {
                    if (!this._formatPatternTime4.matcher(dateTimeString).matches()) break;
                    DateFormat dateFormat = this._formatDateTimePattern4;
                    synchronized (dateFormat) {
                        result = this._formatDateTimePattern4.parse(dateTimeString);
                        break;
                    }
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }
}

