package eu.dnetlib.rmi.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Enum of the available HadoopBlackboardActions.
 */
public enum DedupBlackboardActions {

	/**
	 * The duplicate scan Job.
	 */
	DUPLICATE_SCAN,
	/**
	 * The close similarity mesh job.
	 */
	CLOSE_MESH;

	public static Set<String> asStringSet() {
		return new HashSet<>(asStringList());
	}

	public static List<String> asStringList() {
		return asList().stream().map(it -> it.toString()).collect(Collectors.toList());
	}

	public static List<DedupBlackboardActions> asList() {
		return Arrays.asList(DedupBlackboardActions.values());
	}
}
