/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMOpaqueResource
implements OpaqueResource {
    private static final String XPATH_ERROR = "cannot compile xpath expression";
    private static final String VALUE_ATTR = "value";
    private static final Log log = LogFactory.getLog(DOMOpaqueResource.class);
    private String resourceId;
    private String resourceType;
    private String resourceKind;
    private String resourceUri;
    private Date modificationDate;
    private Document dom;
    private Transformer transformer;

    public DOMOpaqueResource(Document dom) throws XPathExpressionException {
        this.dom = dom;
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("transformer configuration", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("transformer configuration", e);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        this.resourceId = xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER/@value", dom);
        this.resourceType = xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_TYPE/@value", dom);
        this.resourceKind = xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_KIND/@value", dom);
        this.resourceUri = xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_URI/@value", dom);
        String modificationDateSource = xpath.evaluate("/RESOURCE_PROFILE/HEADER/DATE_OF_CREATION/@value", dom);
        try {
            this.modificationDate = new DateUtils().parse(modificationDateSource);
        }
        catch (IllegalStateException e) {
            log.debug((Object)("invalid date '" + modificationDateSource + "'"), (Throwable)e);
        }
    }

    @Override
    public Document asDom() {
        return this.getDom();
    }

    @Override
    public String asString() {
        StringWriter writer = new StringWriter();
        try {
            this.transformer.transform(new DOMSource(this.getDom()), new StreamResult(writer));
        }
        catch (TransformerException e) {
            log.fatal((Object)"cannot serialize document", (Throwable)e);
            return null;
        }
        return writer.toString();
    }

    public Document getDom() {
        return this.dom;
    }

    public void setDom(Document dom) {
        this.dom = dom;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceId(String identifier) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element idEl = (Element)xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER", this.asDom(), XPathConstants.NODE);
            idEl.setAttribute(VALUE_ATTR, identifier);
            this.resourceId = identifier;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(XPATH_ERROR, e);
        }
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public String getResourceKind() {
        return this.resourceKind;
    }

    @Override
    public void setResourceKind(String resourceKind) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element kindEl = (Element)xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_KIND", this.asDom(), XPathConstants.NODE);
            kindEl.setAttribute(VALUE_ATTR, resourceKind);
            this.resourceKind = resourceKind;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(XPATH_ERROR, e);
        }
    }

    @Override
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date modificationDate) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element idEl = (Element)xpath.evaluate("/RESOURCE_PROFILE/HEADER/DATE_OF_CREATION", this.asDom(), XPathConstants.NODE);
            if (idEl == null) {
                log.warn((Object)("resource with type " + this.getResourceType() + " has no date of creation element"));
                return;
            }
            idEl.setAttribute(VALUE_ATTR, new DateUtils(modificationDate).getDateAsISO8601String());
            this.modificationDate = modificationDate;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(XPATH_ERROR, e);
        }
    }

    @Override
    public String getResourceUri() {
        return this.resourceUri;
    }

    @Override
    public void setResourceUri(String resourceUri) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element uriEl = (Element)xpath.evaluate("/RESOURCE_PROFILE/HEADER/RESOURCE_URI", this.asDom(), XPathConstants.NODE);
            uriEl.setAttribute(VALUE_ATTR, resourceUri);
            this.resourceUri = resourceUri;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(XPATH_ERROR, e);
        }
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

