package eu.dnetlib.springutils.collections;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;


/**
 * very useful in unit tests when you want to read many resources obtained from the spring resource loader into a
 * collection of strings.
 * 
 * @author marko
 * 
 */
public class ResourceReaderCollectionUtils {

	/**
	 * construct a ResourceReaderCollectionUtils from a collection of resources.
	 * @param coll
	 */
	public static Collection<String> createCollection(Collection<Resource> coll) {
		return coll.stream().map(resource -> {
			try {
				return IOUtils.toString(resource.getInputStream());
			} catch (IOException e) {
				throw new IllegalArgumentException("cannot read resource", e);
			}
		}).collect(Collectors.toList());


	}

}
