/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.query;

import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.utils.MDFormatReader;
import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.utils.MetadataReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Weights
extends HashMap<MetadataReference, Map<String, String>> {
    private static final long serialVersionUID = -3517914310574484765L;
    private static final Log log = LogFactory.getLog(Weights.class);
    @Autowired
    private ServiceTools serviceTools;
    @Autowired
    private MDFormatReader mdFormatReader;

    public void initialize() throws IndexClientException {
        log.info((Object)"initializing weights");
        for (MetadataReference mdRef : this.serviceTools.listMDRefs()) {
            this.put(mdRef, this.mdFormatReader.getAttributeMap(mdRef, "weight"));
        }
        log.info((Object)"weights initialization completed");
    }

    @Override
    public Map<String, String> put(MetadataReference mdRef, Map<String, String> w) {
        log.info((Object)("[" + mdRef + "] adding weights: " + w));
        return super.put(mdRef, w);
    }

    @Override
    public Map<String, String> get(Object mdRef) {
        Map<String, String> map = (Map<String, String>)super.get(mdRef);
        return map != null ? map : this.initAndGet(mdRef);
    }

    private Map<String, String> initAndGet(Object mdRef) {
        try {
            this.initialize();
        }
        catch (IndexClientException e) {
            throw new RuntimeException(e);
        }
        return (Map)super.get(mdRef);
    }
}

