package eu.dnetlib.clients.index.client;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

/**
 * The Class GlobalIndexClientFactory.
 */

/**
 * The Class ResolvingIndexClientFactory.
 */
public class ResolvingIndexClientFactory {

	/**
	 * The index client factories.
	 */
	@Autowired(required = false)
	private List<IndexClientFactory> indexClientFactories = new ArrayList<>();

	/**
	 * Gets the client.
	 *
	 * @param format
	 *            the format
	 * @param layout
	 *            the layout
	 * @param interpretation
	 *            the interpretation
	 * @param backendId
	 *            the backend id
	 * @return the client
	 * @throws IndexClientException
	 *             the index client exception
	 */
	public IndexClient getClient(final String format, final String layout, final String interpretation, final String backendId) throws IndexClientException {
		for (final IndexClientFactory factory : indexClientFactories) {
			if (factory.getBackendId().equalsIgnoreCase(backendId)) { return factory.getClient(format, layout, interpretation); }
		}
		throw new IndexClientException("No client for bakendId: " + backendId);
	}

}
