package eu.dnetlib.rmi.data;

import java.util.Date;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.common.ResultSet;

@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface DatabaseService extends BaseService {

	@WebMethod(operationName = "dumpTable")
	ResultSet<String> dumpTable(@WebParam(name = "db") String db, @WebParam(name = "table") String table) throws DatabaseException;

	@WebMethod(operationName = "dumpTableAndLogs")
	ResultSet<String> dumpTableAndLogs(
			@WebParam(name = "db") String db,
			@WebParam(name = "table") String table,
			@WebParam(name = "from") Date from,
			@WebParam(name = "until") Date until) throws DatabaseException;

	@WebMethod(operationName = "importFromEPR")
	void importFromEPR(@WebParam(name = "db") String db, @WebParam(name = "epr") ResultSet<String> epr, @WebParam(name = "xslt") String xslt)
			throws DatabaseException;

	@WebMethod(operationName = "searchSQL")
	ResultSet<String> searchSQL(@WebParam(name = "db") String db, @WebParam(name = "sql") String sql) throws DatabaseException;

	@WebMethod(operationName = "alternativeSearchSQL")
	ResultSet<String> alternativeSearchSQL(@WebParam(name = "db") String db,
			@WebParam(name = "sql") String sql,
			@WebParam(name = "sqlForSize") String sqlForSize) throws DatabaseException;

	@WebMethod(operationName = "updateSQL")
	void updateSQL(@WebParam(name = "db") String db, @WebParam(name = "sql") String sql) throws DatabaseException;

	@WebMethod(operationName = "xsltSearchSQL")
	ResultSet<String> xsltSearchSQL(@WebParam(name = "db") String db, @WebParam(name = "sql") String sql, @WebParam(name = "xslt") String xslt)
			throws DatabaseException;

	@WebMethod(operationName = "alternativeXsltSearchSQL")
	ResultSet<String> alternativeXsltSearchSQL(@WebParam(name = "db") String db,
			@WebParam(name = "sql") String sql,
			@WebParam(name = "sqlForSize") String sqlForSize,
			@WebParam(name = "xslt") String xslt) throws DatabaseException;

	@WebMethod(operationName = "contains")
	boolean contains(@WebParam(name = "db") String db,
			@WebParam(name = "table") String table,
			@WebParam(name = "column") String column,
			@WebParam(name = "value") String value) throws DatabaseException;

}
