package eu.dnetlib.rmi.data.hadoop.actionmanager;

public enum Provenance {
	sysimport_crosswalk_repository,
	sysimport_crosswalk_aggregator,
	sysimport_crosswalk_entityregistry,
	sysimport_crosswalk_datasetarchive,
	sysimport_crosswalk_cris,
	sysimport_mining_repository,
	sysimport_mining_aggregator,
	sysimport_mining_entityregistry,
	sysimport_mining_datasetarchive,
	sysimport_mining_cris,

	user_claim_pid,
	user_claim_search,
	user_insert;

	/**
	 * Use this instead of original valueOf if term contain ":".
	 *
	 * @param s
	 * @return
	 */
	public static Provenance convert(String s) {
		return Provenance.valueOf(s.replaceAll(":", "_"));
	}

	@Override
	public String toString() {
		return super.toString().replaceAll("_", ":");
	}
}
