package eu.dnetlib.rmi.provision;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.utils.MetadataReference;

@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface OAIStoreService extends BaseService {

	@WebMethod
	void feed(@WebParam(name = "recordsEpr") final ResultSet<String> recordsEpr,
			@WebParam(name = "mdformat") final MetadataReference mdfInfo,
			@WebParam(name = "dbName") final String dbName);

	@WebMethod(operationName = "feedWithSource")
	void feed(@WebParam(name = "recordsEpr") final ResultSet<String> recordsEpr,
			@WebParam(name = "mdformat") final MetadataReference mdfInfo,
			@WebParam(name = "recordSource") final String recordSource,
			@WebParam(name = "dbName") final String dbName);

	@WebMethod
	void updateSetCounts(@WebParam(name = "dbName") final String dbName);

	@WebMethod(operationName = "updateSetCountsForMDF")
	void updateSetCounts(@WebParam(name = "mdformat") final MDFInfo mdfInfo, @WebParam(name = "dbName") final String dbName);

	@WebMethod
	void refreshConfiguration(@WebParam(name = "dbName") final String dbName);

	@WebMethod
	void ensureIndexes(@WebParam(name = "dbName") final String dbName);

	@WebMethod(operationName = "ensureIndexOnMDF")
	void ensureIndexes(@WebParam(name = "mdformat") final MDFInfo mdfInfo, @WebParam(name = "dbName") final String dbName);
}
