/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.enabling;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ISLookUpClient {
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private ISLookUpService lookUpService;

    public void initialize() {
        log.debug((Object)"Initializing the ISLookUpService");
        this.setLookUpService(this.serviceLocator.getService(ISLookUpService.class));
    }

    public String getResourceProfileById(String id) throws ISLookUpException {
        return this.getLookUpService().getResourceProfile(id);
    }

    public String getResourceProfileByQuery(String xquery) throws ISLookUpException {
        return this.getLookUpService().getResourceProfileByQuery(xquery);
    }

    public List<String> search(String xquery) throws ISLookUpException {
        return this.getLookUpService().quickSearchProfile(xquery);
    }

    public <T> List<T> search(String query, Class<T> clazz, String separator) throws ISLookUpException {
        try {
            return this.getLookUpService().quickSearchProfile(query).stream().map(it -> this.convertResult((String)it, clazz, separator)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            throw new ISLookUpException(e);
        }
    }

    public <T> List<T> searchAndMapToClassByConstructor(String query, Class<T> clazz, String separator) throws ISLookUpException {
        List<String> results = this.getLookUpService().quickSearchProfile(query);
        try {
            return results.stream().map(result -> this.constructObjectByResult(clazz, separator, (String)result)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            throw new ISLookUpException(e);
        }
    }

    public <T> T constructObjectByResult(Class<T> clazz, String separator, String result) {
        try {
            if (result == null) {
                throw new RuntimeException("the result of query is null");
            }
            List<String> splittedValues = Arrays.asList(result.split(separator));
            if (StringUtils.endsWith((CharSequence)result, (CharSequence)separator)) {
                splittedValues.add("");
            }
            ArrayList types = new ArrayList();
            splittedValues.forEach(it -> types.add(String.class));
            return clazz.getDeclaredConstructor(types.toArray(new Class[0])).newInstance(splittedValues.toArray(new String[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T convertResult(String result, Class<T> clazz, String separator) {
        if (result == null) {
            throw new RuntimeException("the result of query is null");
        }
        List<String> splittedValues = Arrays.asList(result.split(separator));
        if (StringUtils.endsWith((CharSequence)result, (CharSequence)separator)) {
            splittedValues.add("");
        }
        if (splittedValues.size() % 2 != 0) {
            throw new RuntimeException("the number of argument of result must be key" + separator + "value in  " + result);
        }
        try {
            HashMap<String, String> keyValuesMap = new HashMap<String, String>();
            for (int i = 0; i < splittedValues.size() - 1; i += 2) {
                keyValuesMap.put(splittedValues.get(i), splittedValues.get(i + 1));
            }
            T object = clazz.newInstance();
            PropertyAccessorFactory.forBeanPropertyAccess(object).setPropertyValues(keyValuesMap);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException("Error on creating object of class: " + clazz.getCanonicalName());
        }
    }

    public ISLookUpService getLookUpService() {
        if (this.lookUpService == null) {
            this.initialize();
        }
        return this.lookUpService;
    }

    public void setLookUpService(ISLookUpService lookUpService) {
        this.lookUpService = lookUpService;
    }
}

