/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.model.impl;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.model.AnyMap;
import eu.dnetlib.clients.index.model.AnySeq;
import eu.dnetlib.clients.index.model.InvalidValueTypeException;
import eu.dnetlib.clients.index.model.Value;
import eu.dnetlib.clients.index.model.impl.AbstractAny;
import eu.dnetlib.clients.index.model.impl.ValueImpl;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class AnyMapImpl
extends AbstractAny
implements AnyMap {
    private static final long serialVersionUID = 1L;
    private final Map<String, Any> _anyMap = new LinkedHashMap<String, Any>();

    AnyMapImpl() {
        super(Any.ValueType.MAP);
    }

    @Override
    public void add(String key, Any value) {
        Any any = this._anyMap.get(key);
        AnySeq anySeq = null;
        if (any == null) {
            anySeq = this.getFactory().createAnySeq();
            this._anyMap.put(key, anySeq);
        } else if (any.isValue() || any.isMap()) {
            anySeq = this.getFactory().createAnySeq();
            anySeq.add(any);
            this._anyMap.put(key, anySeq);
        } else {
            anySeq = (AnySeq)any;
        }
        anySeq.add(value);
    }

    @Override
    public void clear() {
        this._anyMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._anyMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._anyMap.keySet();
    }

    @Override
    public Any put(String key, String value) {
        try {
            return this.put(key, new ValueImpl(Any.ValueType.STRING, value));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot add value for key: " + key, e);
        }
    }

    @Override
    public Any put(String key, Number value) {
        if (value == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        if (value instanceof Double) {
            return this.put(key, new ValueImpl(Any.ValueType.DOUBLE, value));
        }
        if (value instanceof Long) {
            return this.put(key, new ValueImpl(Any.ValueType.LONG, value));
        }
        if (value instanceof Integer) {
            return this.put(key, new ValueImpl(Any.ValueType.LONG, value.longValue()));
        }
        if (value instanceof Short) {
            return this.put(key, new ValueImpl(Any.ValueType.LONG, value.longValue()));
        }
        if (value instanceof Byte) {
            return this.put(key, new ValueImpl(Any.ValueType.LONG, value.longValue()));
        }
        return this.put(key, new ValueImpl(Any.ValueType.DOUBLE, value.doubleValue()));
    }

    @Override
    public Any put(String key, Boolean value) {
        return this.put(key, new ValueImpl(Any.ValueType.BOOLEAN, value));
    }

    @Override
    public Any put(String key, Any value) {
        if (value == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        return this._anyMap.put(key, value);
    }

    @Override
    public int size() {
        return this._anyMap.size();
    }

    @Override
    public Collection<Any> values() {
        return this._anyMap.values();
    }

    @Override
    public Iterator<Any> iterator() {
        return this._anyMap.values().iterator();
    }

    @Override
    public AnyMap getMap(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue.isMap()) {
                return (AnyMap)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to AnyMap.");
        }
        return null;
    }

    @Override
    public AnySeq getSeq(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue.isSeq()) {
                return (AnySeq)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to AnySeq.");
        }
        return null;
    }

    @Override
    public Value getValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return (Value)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to Value.");
        }
        return null;
    }

    @Override
    public String getStringValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asString();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to String.");
        }
        return null;
    }

    @Override
    public Double getDoubleValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDouble();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to double.");
        }
        return null;
    }

    @Override
    public Long getLongValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asLong();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to long.");
        }
        return null;
    }

    @Override
    public Boolean getBooleanValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asBoolean();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to boolean.");
        }
        return null;
    }

    @Override
    public Date getDateValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDate();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to Date.");
        }
        return null;
    }

    @Override
    public Date getDateTimeValue(String key) {
        Any anyValue = this.get(key);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDateTime();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to DateTime.");
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._anyMap == null ? 0 : this._anyMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyMapImpl other = (AnyMapImpl)obj;
        return !(this._anyMap == null ? other._anyMap != null : !this._anyMap.equals(other._anyMap));
    }

    public String toString() {
        return this._anyMap.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._anyMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._anyMap.containsValue(value);
    }

    @Override
    public Any get(Object key) {
        return this._anyMap.get(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Any> map) {
        this._anyMap.putAll(map);
    }

    @Override
    public Any remove(Object key) {
        return this._anyMap.remove(key);
    }

    @Override
    public Set<Map.Entry<String, Any>> entrySet() {
        return this._anyMap.entrySet();
    }

    @Override
    public AnyMap asMap() {
        return this;
    }

    @Override
    public AnyMap getMap(String key, boolean create) {
        AnyMap val = this.getMap(key);
        if (val == null && create) {
            val = this.getFactory().createAnyMap();
            this.put(key, val);
        }
        return val;
    }

    @Override
    public AnySeq getSeq(String key, boolean create) {
        AnySeq val = this.getSeq(key);
        if (val == null && create) {
            val = this.getFactory().createAnySeq();
            this.put(key, val);
        }
        return val;
    }
}

