/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.model.impl;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.model.AnyMap;
import eu.dnetlib.clients.index.model.AnySeq;
import eu.dnetlib.clients.index.model.InvalidValueTypeException;
import eu.dnetlib.clients.index.model.Value;
import eu.dnetlib.clients.index.model.impl.AbstractAny;
import eu.dnetlib.clients.index.model.impl.ValueImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public final class AnySeqImpl
extends AbstractAny
implements AnySeq {
    private static final long serialVersionUID = 1L;
    private final List<Any> _anyList = new ArrayList<Any>();

    AnySeqImpl() {
        super(Any.ValueType.SEQ);
    }

    @Override
    public boolean add(Any value) {
        if (value == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        return this._anyList.add(value);
    }

    @Override
    public boolean add(String e) {
        return this.add(new ValueImpl(Any.ValueType.STRING, e));
    }

    @Override
    public boolean add(Number n) {
        if (n instanceof Double) {
            return this.add(new ValueImpl(Any.ValueType.DOUBLE, n));
        }
        if (n instanceof Long) {
            return this.add(new ValueImpl(Any.ValueType.LONG, n));
        }
        if (n instanceof Integer || n instanceof Short || n instanceof Byte) {
            return this.add(new ValueImpl(Any.ValueType.LONG, n.longValue()));
        }
        return this.add(new ValueImpl(Any.ValueType.DOUBLE, n.doubleValue()));
    }

    @Override
    public void add(int index, Any element) {
        if (element == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        this._anyList.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Any> c) {
        return this._anyList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Any> c) {
        return this._anyList.addAll(index, c);
    }

    @Override
    public void clear() {
        this._anyList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this._anyList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._anyList.containsAll(c);
    }

    @Override
    public Any get(int index) {
        return this._anyList.get(index);
    }

    @Override
    public Any set(int index, Any element) {
        if (element == null) {
            throw new IllegalArgumentException("The value of any Any must not be null.");
        }
        return this._anyList.set(index, element);
    }

    @Override
    public int indexOf(Object o) {
        return this._anyList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this._anyList.isEmpty();
    }

    @Override
    public Iterator<Any> iterator() {
        return this._anyList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._anyList.lastIndexOf(o);
    }

    @Override
    public ListIterator<Any> listIterator() {
        return this._anyList.listIterator();
    }

    @Override
    public ListIterator<Any> listIterator(int index) {
        return this._anyList.listIterator(index);
    }

    @Override
    public Any remove(int index) {
        return this._anyList.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this._anyList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._anyList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._anyList.retainAll(c);
    }

    @Override
    public int size() {
        return this._anyList.size();
    }

    @Override
    public List<Any> subList(int fromIndex, int toIndex) {
        return this._anyList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this._anyList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._anyList.toArray(a);
    }

    @Override
    public AnyMap getMap(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue.isMap()) {
                return (AnyMap)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to AnyMap.");
        }
        return null;
    }

    @Override
    public AnySeq getSeq(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue.isSeq()) {
                return (AnySeq)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to AnySeq.");
        }
        return null;
    }

    @Override
    public Value getValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return (Value)anyValue;
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to Value.");
        }
        return null;
    }

    @Override
    public String getStringValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asString();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to String.");
        }
        return null;
    }

    @Override
    public Double getDoubleValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDouble();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to double.");
        }
        return null;
    }

    @Override
    public Long getLongValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asLong();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to long.");
        }
        return null;
    }

    @Override
    public Boolean getBooleanValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asBoolean();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to boolean.");
        }
        return null;
    }

    @Override
    public Date getDateValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDate();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to Date.");
        }
        return null;
    }

    @Override
    public Date getDateTimeValue(int index) {
        Any anyValue = this.get(index);
        if (anyValue != null) {
            if (anyValue instanceof Value) {
                return ((Value)anyValue).asDateTime();
            }
            throw new InvalidValueTypeException("Cannot convert value of type '" + (Object)((Object)anyValue.getValueType()) + "' to DateTime.");
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._anyList == null ? 0 : this._anyList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnySeqImpl)) {
            return false;
        }
        AnySeqImpl other = (AnySeqImpl)obj;
        return !(this._anyList == null ? other._anyList != null : !this._anyList.equals(other._anyList));
    }

    public String toString() {
        return this._anyList.toString();
    }

    @Override
    public AnySeq asSeq() {
        return this;
    }

    @Override
    public List<String> asStrings() {
        ArrayList<String> values = new ArrayList<String>(this._anyList.size());
        values.addAll(this._anyList.stream().map(any -> any.asValue().asString()).collect(Collectors.toList()));
        return values;
    }

    @Override
    public List<Long> asLongs() {
        return this._anyList.stream().map(any -> any.asValue().asLong()).collect(Collectors.toList());
    }
}

