/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLSortNode;
import org.z3950.zing.cql.CQLTermNode;

public class Pruner {
    public static final String DNET_URI = "NAMESPACE";
    private static final Log log = LogFactory.getLog(Pruner.class);
    private String optionUri = "NAMESPACE";

    CQLNode parse(String cqlQuery) throws CQLParseException, IOException {
        return new CQLParser().parse(cqlQuery);
    }

    public Result prune(CQLNode root) {
        return this.prune(new HashMap<String, String>(), root);
    }

    public Result prune(Map<String, String> prefixes, CQLNode root) {
        if (root instanceof CQLBooleanNode) {
            return this.prune(prefixes, (CQLBooleanNode)root);
        }
        if (root instanceof CQLPrefixNode) {
            return this.prune(prefixes, (CQLPrefixNode)root);
        }
        if (root instanceof CQLSortNode) {
            return this.prune(prefixes, (CQLSortNode)root);
        }
        return new Result(root, (List<String>)new ArrayList<String>());
    }

    public Result prune(Map<String, String> prefixes, CQLSortNode node) {
        Result res = this.prune(prefixes, node.subtree);
        node.subtree = res.getNode();
        res.setNode((CQLNode)node);
        return res;
    }

    public Result prune(Map<String, String> prefixes, CQLPrefixNode node) {
        HashMap subPrefixes = Maps.newHashMap(prefixes);
        subPrefixes.put(node.prefix.name, node.prefix.identifier);
        if (this.isOption((Map<String, String>)subPrefixes, node.subtree)) {
            return new Result(null, Lists.newArrayList((Object[])new String[]{this.getOption(node.subtree)}));
        }
        boolean pruneThisPrefix = node.prefix.identifier.equals(this.optionUri);
        if (pruneThisPrefix) {
            return this.prune((Map<String, String>)subPrefixes, node.subtree);
        }
        Result res = this.prune((Map<String, String>)subPrefixes, node.subtree);
        node.subtree = res.getNode();
        res.setNode((CQLNode)node);
        return res;
    }

    public Result prune(Map<String, String> prefixes, CQLBooleanNode node) {
        return this.prune(prefixes, node, node.left, node.right);
    }

    public Result prune(Map<String, String> prefixes, CQLBooleanNode bool, CQLNode left, CQLNode right) {
        if (this.isOption(prefixes, left) && this.isOption(prefixes, right)) {
            ArrayList r = Lists.newArrayList((Object[])new Result[]{this.trimOption(prefixes, left, right), this.trimOption(prefixes, right, left)});
            return new Result(null, r.stream().filter(it -> it != null).map(res -> res.getOptions()).flatMap(strings -> strings.stream()).collect(Collectors.toList()));
        }
        Result res2 = this.anyNotNull(this.trimOption(prefixes, left, right), this.trimOption(prefixes, right, left));
        if (res2 != null) {
            return res2;
        }
        Result leftResult = this.prune(prefixes, left);
        Result rightResult = this.prune(prefixes, right);
        bool.left = leftResult.getNode();
        bool.right = rightResult.getNode();
        return new Result(this.clean(bool), Iterables.concat(leftResult.getOptions(), rightResult.getOptions()));
    }

    public <T> T anyNotNull(T a, T b) {
        if (a != null) {
            return a;
        }
        return b;
    }

    public Result trimOption(Map<String, String> prefixes, CQLNode a, CQLNode b) {
        log.debug((Object)("trim option?" + prefixes + " a " + a.toCQL()));
        if (this.isOption(prefixes, a)) {
            log.debug((Object)"IS OPTION...");
            return this.trimOption(prefixes, this.prefixFromOption(a), this.getOption(a), b);
        }
        log.debug((Object)"IS NOT OPTION");
        return null;
    }

    public Result trimOption(Map<String, String> prefixes, String ns, String o, CQLNode subtree) {
        log.debug((Object)("trimming " + prefixes + " ns " + ns + " o " + o));
        String namespaceUri = prefixes.get(ns);
        if (!this.optionUri.equals(namespaceUri)) {
            return null;
        }
        Result res = this.prune(prefixes, subtree);
        return new Result(res.getNode(), Iterables.concat((Iterable)Lists.newArrayList((Object[])new String[]{o}), res.getOptions()));
    }

    private CQLNode clean(CQLBooleanNode bool) {
        if (bool.left == null) {
            return bool.right;
        }
        if (bool.right == null) {
            return bool.left;
        }
        return bool;
    }

    public String getOption(CQLNode node) {
        return this.indexFromOption(node) + "=" + this.termFromOption(node);
    }

    private String indexFromOption(CQLNode node) {
        return ((CQLTermNode)node).getIndex().replaceAll("[a-z]*\\.(.+)", "$1");
    }

    private String termFromOption(CQLNode node) {
        return ((CQLTermNode)node).getTerm();
    }

    public String prefixFromOption(String option) {
        return option.replaceAll("([a-z]*)\\..+", "$1");
    }

    public String prefixFromOption(CQLNode node) {
        if (node instanceof CQLTermNode) {
            return this.prefixFromOption(((CQLTermNode)node).getIndex());
        }
        return null;
    }

    public boolean isOption(Map<String, String> prefixes, String option) {
        return prefixes.containsKey(this.prefixFromOption(option)) && prefixes.get(this.prefixFromOption(option)).equals(this.getOptionUri());
    }

    public boolean isOption(Map<String, String> prefixes, CQLNode node) {
        if (node instanceof CQLTermNode) {
            return this.isOption(prefixes, ((CQLTermNode)node).getIndex());
        }
        return false;
    }

    public String getOptionUri() {
        return this.optionUri;
    }

    public void setOptionUri(String optionUri) {
        this.optionUri = optionUri;
    }

    public class Result {
        private CQLNode node;
        private List<String> options;

        public Result(CQLNode node, List<String> options) {
            this.node = node;
            this.options = options;
        }

        public Result(CQLNode node, Iterable<String> concat) {
            this.node = node;
            this.options = Lists.newArrayList(concat);
        }

        public CQLNode getNode() {
            return this.node;
        }

        public void setNode(CQLNode node) {
            this.node = node;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public void setOptions(List<String> options) {
            this.options = options;
        }

        public Map<String, List<String>> getOptionMap() {
            HashMap<String, List<String>> res = new HashMap<String, List<String>>();
            for (String opt : this.options) {
                String[] k = opt.split("=");
                ArrayList<String> l = (ArrayList<String>)res.get(k[0]);
                if (l == null) {
                    l = new ArrayList<String>();
                }
                l.add(k[1]);
                res.put(k[0], l);
            }
            return res;
        }
    }
}

