/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.conf;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyFetcher
extends PropertyResourceConfigurer
implements InitializingBean {
    private static final Log log = LogFactory.getLog(PropertyFetcher.class);
    boolean unchangedHostname = false;
    boolean unchangedPort = true;
    private Properties props;

    public void afterPropertiesSet() throws Exception {
        this.props = this.mergeProperties();
        this.convertProperties(this.props);
        log.debug((Object)("FOUND A container.hostname property " + this.props.getProperty("container.hostname")));
        if ("localhost".equals(this.props.getProperty("container.hostname"))) {
            this.unchangedHostname = true;
        }
        if (this.props.getProperty("container.port") != null) {
            log.debug((Object)("FOUND A container.port property " + this.props.getProperty("container.port")));
            this.unchangedPort = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("HOST unchanged? " + this.unchangedHostname));
            log.debug((Object)("PORT unchanged? " + this.unchangedPort));
            for (Map.Entry<Object, Object> e : this.props.entrySet()) {
                log.debug((Object)("system property: " + e.getKey() + " --> " + e.getValue()));
            }
        }
    }

    protected void processProperties(ConfigurableListableBeanFactory arg0, Properties props) throws BeansException {
    }

    public boolean isUnchangedHostname() {
        return this.unchangedHostname;
    }

    public void setUnchangedHostname(boolean unchangedHostname) {
        this.unchangedHostname = unchangedHostname;
    }

    public boolean isUnchangedPort() {
        return this.unchangedPort;
    }

    public void setUnchangedPort(boolean unchangedPort) {
        this.unchangedPort = unchangedPort;
    }

    public String getProperty(String key) {
        if (!this.props.containsKey(key)) {
            log.warn((Object)("No defined property: " + key));
        }
        return this.props.getProperty(key);
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }
}

