/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.conf;

import eu.dnetlib.conf.AbstractWebappContextProperty;
import eu.dnetlib.conf.PropertyFetcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;

public class WebappContextProperyFactory
extends AbstractWebappContextProperty
implements FactoryBean<Properties> {
    private static final Log log = LogFactory.getLog(WebappContextProperyFactory.class);
    private boolean resolveHostname = false;
    private PropertyFetcher propertyFetcher;

    public Properties getObject() throws Exception {
        Properties props = new Properties();
        if (this.getContext() == null) {
            return props;
        }
        props.setProperty("container.context", this.getContext());
        log.debug((Object)"trying to autodetect port and hostame");
        if (this.propertyFetcher.isUnchangedPort()) {
            log.debug((Object)"PORT IS NOT OVERRIDDEN, autodetecting");
            int port = this.getPort(this.getServletContext());
            if (port > 0) {
                props.setProperty("container.port", Integer.toString(port));
            }
        } else {
            log.debug((Object)"PORT IS OVERRIDDEN, NOT autodetecting");
        }
        if (this.propertyFetcher.isUnchangedHostname()) {
            log.debug((Object)"HOST IS NOT OVERRIDDEN, autodetecting");
            String hostname = this.getHost(this.getServletContext());
            if (hostname != null) {
                props.setProperty("container.hostname", hostname);
            }
        } else {
            log.debug((Object)"HOST IS OVERRIDDEN, NOT autodetecting");
        }
        return props;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private int getPort(ServletContext servletContext) {
        try {
            return this.getContainerPort(servletContext);
        }
        catch (Throwable e) {
            log.warn((Object)"cannot obtain port from container...strange: I thought it would work both on jetty and tomcat7...)", e);
            return 0;
        }
    }

    private int getContainerPort(ServletContext servletContext) {
        try {
            Container c;
            StandardContext sCtx;
            Object o = FieldUtils.readField((Object)servletContext, (String)"context", (boolean)true);
            StandardContext container = sCtx = (StandardContext)FieldUtils.readField((Object)o, (String)"context", (boolean)true);
            for (c = container.getParent(); c != null && !(c instanceof StandardEngine); c = c.getParent()) {
            }
            if (c != null) {
                StandardEngine engine = (StandardEngine)c;
                for (Connector connector : engine.getService().findConnectors()) {
                    if (connector.getPort() <= 0) continue;
                    return connector.getPort();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private String getHost(ServletContext servletContext) {
        try {
            if (this.resolveHostname) {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            return InetAddress.getLocalHost().toString().split("/")[1];
        }
        catch (UnknownHostException e) {
            log.warn((Object)"cannot obtain hostname from JVM", (Throwable)e);
            return null;
        }
    }

    public boolean isResolveHostname() {
        return this.resolveHostname;
    }

    public void setResolveHostname(boolean resolveHostname) {
        this.resolveHostname = resolveHostname;
    }

    public PropertyFetcher getPropertyFetcher() {
        return this.propertyFetcher;
    }

    @Required
    public void setPropertyFetcher(PropertyFetcher propertyFetcher) {
        this.propertyFetcher = propertyFetcher;
    }
}

