/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.cql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLTermNode;
import org.z3950.zing.cql.ModifierSet;

public class CqlGroup {
    public static final String defaultTerm = "cql.filtered";

    private static Map<String, CQLNode> doGroup(CQLTermNode node, List<String> fields, Map<String, CQLNode> groups) {
        if (CqlGroup.isTermNodeToGroup(node, fields)) {
            String term = node.getIndex().toLowerCase();
            if (groups.get(term) == null) {
                groups.put(term, (CQLNode)node);
            }
            CQLNode group = groups.get(term);
            CQLAndNode andNode = new CQLAndNode(group, (CQLNode)node, new ModifierSet("and"));
            if (!groups.containsValue(node)) {
                groups.put(term, (CQLNode)andNode);
            }
        }
        return groups;
    }

    private static boolean isTermNodeToGroup(CQLTermNode node, List<String> fields) {
        return fields.contains(node.getIndex().toLowerCase());
    }

    public Map<String, CQLNode> group(CQLNode node, List<String> fields) {
        return node != null ? this.doGroup(node, fields, new HashMap<String, CQLNode>()) : new HashMap<String, CQLNode>();
    }

    private Map<String, CQLNode> doGroup(CQLNode node, List<String> fields, Map<String, CQLNode> groups) {
        if (node instanceof CQLBooleanNode) {
            return this.doGroup((CQLBooleanNode)node, fields, groups);
        }
        if (node instanceof CQLTermNode) {
            return CqlGroup.doGroup((CQLTermNode)node, fields, groups);
        }
        if (node instanceof CQLPrefixNode) {
            return groups;
        }
        throw new RuntimeException("error choice");
    }

    private Map<String, CQLNode> doGroup(CQLBooleanNode node, List<String> fields, Map<String, CQLNode> groups) {
        this.doGroup(node.left, fields, groups);
        this.doGroup(node.right, fields, groups);
        return groups;
    }
}

