/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.EntryPointDescriptor;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorGroup;
import eu.dnetlib.enabling.inspector.EntryPointDescriptorModel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class AbstractInspectorController {
    @Autowired
    List<EntryPointDescriptorGroup> entryPointsGroups;

    @PostConstruct
    public void sortEntryPointGroups() {
        Collections.sort(this.entryPointsGroups, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    @ModelAttribute(value="baseUrl")
    public String baseUrl(HttpServletRequest request) {
        return request.getContextPath() + "/mvc/inspector";
    }

    @ModelAttribute(value="entryPointGroups")
    public List<EntryPointDescriptorGroup> entryPointGroups() {
        return this.entryPointsGroups;
    }

    @ModelAttribute(value="entryPoints")
    public <R> List<EntryPointDescriptorModel> entryPoints(HttpServletRequest request) {
        String currentRelativeUrl = request.getPathInfo().replaceAll("/inspector/(.*\\.do).*", "$1");
        return this.entryPointGroups().stream().flatMap(group -> group.getDescriptors().stream().map(it -> this.generateEntryPointDescriptorModel((EntryPointDescriptor)it, currentRelativeUrl))).collect(Collectors.toList());
    }

    private EntryPointDescriptorModel generateEntryPointDescriptorModel(EntryPointDescriptor it, String currentRelativeUrl) {
        return new EntryPointDescriptorModel(it.getName(), it.getRelativeUrl(), currentRelativeUrl.equals(it.getRelativeUrl()), it.isHiddenAsDefault());
    }
}

