/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.tools.BaseServiceUtils;
import eu.dnetlib.rmi.common.BaseService;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;

@WebService(targetNamespace="http://services.dnetlib.eu/")
public abstract class AbstractBaseService
implements BaseService,
Lifecycle {
    private static final Log log = LogFactory.getLog(AbstractBaseService.class);
    private boolean started = false;
    private String profileId;
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private Map<String, String> extraProtocols = new HashMap<String, String>();

    protected String getServiceName() {
        return BaseServiceUtils.getServiceName(this.getClass());
    }

    @Override
    public String identify() {
        return this.getClass().getName();
    }

    @Override
    public void notify(String subscriptionId, String topic, String isId, String message) {
        log.debug((Object)("got notification: " + topic + ", profile: " + isId + ", body: " + message));
    }

    public void start() {
        log.info((Object)("Starting service " + this.identify()));
        if (this.started) {
            log.warn((Object)("Service " + this + "already started, check bean initializations!"));
        }
        this.started = true;
    }

    public boolean isRunning() {
        log.debug((Object)("called isRunning " + this));
        return false;
    }

    public void stop() {
        log.info((Object)("Stopping service " + this));
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map<String, String> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public Map<String, String> getExtraProtocols() {
        return this.extraProtocols;
    }

    public void setExtraProtocols(Map<String, String> extraProtocols) {
        this.extraProtocols = extraProtocols;
    }
}

