/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.miscutils.jaxb.JaxbFactory;
import javax.annotation.Resource;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeletingBlackboardNotificationHandler
extends BlackboardNotificationHandler<BlackboardClientHandler> {
    private static final Log log = LogFactory.getLog(DeletingBlackboardNotificationHandler.class);
    @Resource(name="blackboardMessageFactory")
    private JaxbFactory<BlackboardMessage> messageFactory;

    @Override
    protected void processJob(BlackboardJob job) {
        if (this.getListeners().containsKey(job.getId()) && job.isCompleted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.serializeBlackBoardMessage(job));
            }
            ((BlackboardClientHandler)this.getBlackboardHandler()).delete(job);
        }
        super.processJob(job);
    }

    private String serializeBlackBoardMessage(BlackboardJob job) {
        try {
            return this.getMessageFactory().serialize(job.getMessage());
        }
        catch (JAXBException e) {
            return "cannot serialize blackboard message: " + e.getMessage();
        }
    }

    public JaxbFactory<BlackboardMessage> getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(JaxbFactory<BlackboardMessage> messageFactory) {
        this.messageFactory = messageFactory;
    }
}

