/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandlerChain;
import eu.dnetlib.enabling.tools.blackboard.NotificationHistory;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;

public class NotificationHandlerChainImpl
implements NotificationHandlerChain {
    private static final Log log = LogFactory.getLog(NotificationHandlerChain.class);
    private Collection<NotificationHandler> handlers;
    private TaskExecutor handlerExecutor;
    @Autowired
    private NotificationHistory notificationHistory;

    @Override
    public void notified(String subscrId, String topic, String rsId, String profile) {
        for (NotificationHandler handler : this.handlers) {
            try {
                this.delegateNotification(subscrId, topic, rsId, profile, handler);
            }
            catch (RuntimeException e) {
                log.fatal((Object)("error processing notification handler " + handler), (Throwable)e);
            }
        }
    }

    @Override
    public void delegateNotification(final String subscrId, final String topic, final String rsId, final String profile, final NotificationHandler handler) {
        this.handlerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                handler.notified(subscrId, topic, rsId, profile);
            }
        });
    }

    public Collection<NotificationHandler> getHandlers() {
        return this.handlers;
    }

    @Required
    public void setHandlers(Collection<NotificationHandler> handlers) {
        this.handlers = handlers;
    }

    public TaskExecutor getHandlerExecutor() {
        return this.handlerExecutor;
    }

    @Required
    public void setHandlerExecutor(TaskExecutor handlerExecutor) {
        this.handlerExecutor = handlerExecutor;
    }
}

