/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.registration;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.registration.ServiceRegistrator;
import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ServiceRegistrationManager {
    private static final Log log = LogFactory.getLog(ServiceRegistrationManager.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private ServiceRegistrator registrator;
    private boolean disabled = false;
    @Autowired(required=false)
    private List<Endpoint> services = new ArrayList<Endpoint>();

    public void registerAllServices() {
        if (this.disabled) {
            return;
        }
        this.disabled = true;
        this.getServices().stream().filter(this::filterEndpoint).forEach(this::registerEndpoint);
    }

    private boolean filterEndpoint(Endpoint endpoint) {
        if (!(endpoint.getImplementor() instanceof BaseService)) {
            return false;
        }
        String uri = this.registrator.getEprBuilder().getAddress(endpoint) + "?wsdl";
        try {
            String query = "for $x in //RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + uri + "'] where contains($x//RESOURCE_TYPE/@value/string(), 'Service') return $x//RESOURCE_IDENTIFIER/@value/string()";
            String profId = this.serviceLocator.getService(ISLookUpService.class, true).getResourceProfileByQuery(query);
            ((AbstractBaseService)endpoint.getImplementor()).setProfileId(profId);
            return false;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)("there is no service registered for uri: " + uri));
            return true;
        }
        catch (Throwable e) {
            log.error((Object)"Error filtering endpoint", e);
            this.disabled = false;
            return false;
        }
    }

    private void registerEndpoint(Endpoint endpoint) {
        try {
            AbstractBaseService service = (AbstractBaseService)endpoint.getImplementor();
            String profId = this.registrator.registerService(service, endpoint);
            service.setProfileId(profId);
        }
        catch (Throwable e) {
            log.error((Object)"Error registering endpoint", e);
            this.disabled = false;
        }
    }

    public ServiceRegistrator getRegistrator() {
        return this.registrator;
    }

    @Required
    public void setRegistrator(ServiceRegistrator registrator) {
        this.registrator = registrator;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public List<Endpoint> getServices() {
        return this.services;
    }

    public void setServices(List<Endpoint> services) {
        this.services = services;
    }
}

