/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.function.Function;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class AbstractApplyXslt<K>
implements Function<K, String> {
    private static final String UNKNOWN_XSLT_NAME = "unknown xslt name";
    private static final Log log = LogFactory.getLog(AbstractApplyXslt.class);
    private Transformer transformer;
    private TransformerFactory transformerFactory;
    private String xsltName;

    public AbstractApplyXslt(Resource xslt, TransformerFactory transformerFactory) {
        this(xslt, null, transformerFactory);
    }

    public AbstractApplyXslt(Resource xslt, Map<String, String> parameters, TransformerFactory transformerFactory) {
        this(new StreamSource(AbstractApplyXslt.getInputStream(xslt)), AbstractApplyXslt.getFileName((ClassPathResource)xslt), parameters, transformerFactory);
    }

    public AbstractApplyXslt(String xslt, TransformerFactory transformerFactory) {
        this(xslt, UNKNOWN_XSLT_NAME, transformerFactory);
    }

    public AbstractApplyXslt(String xslt, String name, TransformerFactory transformerFactory) {
        this(xslt, name, null, transformerFactory);
    }

    public AbstractApplyXslt(String xslt, String name, Map<String, String> parameters, TransformerFactory transformerFactory) {
        this(new StreamSource(new StringReader(xslt)), name, parameters, transformerFactory);
    }

    public AbstractApplyXslt(Source xslt, TransformerFactory transformerFactory) {
        this(xslt, UNKNOWN_XSLT_NAME, transformerFactory);
    }

    public AbstractApplyXslt(Source xslt, String name, TransformerFactory transformerFactory) {
        this(xslt, name, null, transformerFactory);
    }

    public AbstractApplyXslt(Source xslt, String name, Map<String, String> parameters, TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
        try {
            this.xsltName = name;
            this.transformer = this.getTransformerFactory().newTransformer(xslt);
            if (!UNKNOWN_XSLT_NAME.equals(name)) {
                this.transformer.setURIResolver(new ExternalResourceURIResolver(name.replaceFirst("[^/]+$", "")));
            }
            if (parameters != null) {
                for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                    this.transformer.setParameter(parameter.getKey(), parameter.getValue());
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)("Problems with transformer!\n" + xslt + "--" + name), e);
            log.error((Object)this.xsltDump(xslt));
            throw new IllegalStateException(e);
        }
    }

    private static InputStream getInputStream(Resource xslt) {
        try {
            return xslt.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getFileName(ClassPathResource xslt) {
        return xslt.getPath();
    }

    private String xsltDump(Source xslt) {
        try {
            Transformer transformer = this.getTransformerFactory().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter outWriter = new StringWriter();
            StreamResult result = new StreamResult(outWriter);
            transformer.transform(xslt, result);
            StringBuffer sb = outWriter.getBuffer();
            return sb.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "error dumping the xslt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(K input) {
        Transformer transformer = this.transformer;
        synchronized (transformer) {
            try {
                StringWriter output = new StringWriter();
                this.transformer.transform(this.toStream(input), new StreamResult(output));
                return output.toString();
            }
            catch (TransformerException e) {
                log.error((Object)"cannot transform record", (Throwable)e);
                log.error((Object)input.toString());
                return "";
            }
        }
    }

    public abstract Source toStream(K var1);

    public abstract String toString(K var1);

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public String getXsltName() {
        return this.xsltName;
    }

    public void setXsltName(String xsltName) {
        this.xsltName = xsltName;
    }

    private class ExternalResourceURIResolver
    implements URIResolver {
        private final String xsltBasePath;

        public ExternalResourceURIResolver(String xsltBasePath) {
            this.xsltBasePath = xsltBasePath;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            String externalResource = this.xsltBasePath + href;
            try {
                log.debug((Object)("trying to load external resource from file system: " + externalResource));
                return new StreamSource(new File(externalResource));
            }
            catch (Throwable e) {
                log.debug((Object)("trying to load external resource from file system: " + externalResource));
                return new StreamSource(AbstractApplyXslt.getInputStream((Resource)new ClassPathResource(externalResource)));
            }
        }
    }
}

