/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import com.google.common.collect.Maps;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class SaxonHelper {
    @Autowired
    private TransformerFactory saxonTransformerFactory;
    private Processor xmlProcessor = new Processor(false);

    public Helper help() {
        return new Helper();
    }

    public class Helper {
        private Serializer serializer;

        Helper() {
            this.serializer = SaxonHelper.this.xmlProcessor.newSerializer();
            this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            this.serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
        }

        public Helper setSerializerProperty(Serializer.Property p, String value) {
            this.serializer.setOutputProperty(p, value);
            return this;
        }

        public XdmItem evaluateSingle(String xmlSource, String xpath, Map<String, String> namespaces) throws SaxonApiException {
            XPathSelector xpathSelector = this.prepareXPathSelector(xpath, namespaces);
            return this.evaluateSingle(xmlSource, xpathSelector);
        }

        public XdmItem evaluateSingle(String xmlSource, XPathSelector xpathSelector) throws SaxonApiException {
            SAXSource source = new SAXSource(new InputSource(new StringReader(xmlSource)));
            DocumentBuilder docBuilder = SaxonHelper.this.xmlProcessor.newDocumentBuilder();
            XdmNode xdmNode = docBuilder.build((Source)source);
            xpathSelector.setContextItem((XdmItem)xdmNode);
            return xpathSelector.evaluateSingle();
        }

        public XPathSelector prepareXPathSelector(String xpath, Map<String, String> namespaces) throws SaxonApiException {
            XPathCompiler compiler = SaxonHelper.this.xmlProcessor.newXPathCompiler();
            for (Map.Entry<String, String> ns : namespaces.entrySet()) {
                compiler.declareNamespace(ns.getKey(), ns.getValue());
            }
            XPathExecutable xpathExecutable = compiler.compile(xpath);
            XPathSelector xpathSelector = xpathExecutable.load();
            return xpathSelector;
        }

        public XPathSelector prepareXPathSelector(String xpath, String nsPrefix, String ns) throws SaxonApiException {
            HashMap map = Maps.newHashMap();
            map.put(nsPrefix, ns);
            return this.prepareXPathSelector(xpath, map);
        }

        public XdmItem evaluateSingle(String xmlSource, String xpath, String nsPrefix, String ns) throws SaxonApiException {
            HashMap map = Maps.newHashMap();
            map.put(nsPrefix, ns);
            return this.evaluateSingle(xmlSource, xpath, map);
        }

        public String evaluateSingleAsString(String xmlSource, String xpath, Map<String, String> namespaces) throws SaxonApiException {
            XdmItem item = this.evaluateSingle(xmlSource, xpath, namespaces);
            if (item != null) {
                XdmNode node = (XdmNode)item;
                return this.serializer.serializeNodeToString(node);
            }
            return null;
        }

        public String evaluateSingleAsString(String xmlSource, XPathSelector xpathSelector) throws SaxonApiException {
            XdmItem item = this.evaluateSingle(xmlSource, xpathSelector);
            if (item != null) {
                XdmNode node = (XdmNode)item;
                return this.serializer.serializeNodeToString(node);
            }
            return null;
        }

        public String evaluateSingleAsString(String xmlSource, String xpath, String nsPrefix, String ns) throws SaxonApiException {
            HashMap map = Maps.newHashMap();
            map.put(nsPrefix, ns);
            return this.evaluateSingleAsString(xmlSource, xpath, map);
        }
    }
}

