/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.function.UnaryOperator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLIndenter
implements UnaryOperator<String> {
    private static final Log log = LogFactory.getLog(XMLIndenter.class);
    private TransformerFactory transformerFactory;

    public XMLIndenter() {
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public XMLIndenter(TransformerFactory tf) {
        this.transformerFactory = tf;
    }

    public String indent(Document document) throws Exception {
        return this.doIndent(document);
    }

    @Override
    public String apply(String unformattedXml) {
        try {
            return this.doIndent(unformattedXml);
        }
        catch (Throwable e) {
            return unformattedXml;
        }
    }

    protected String doIndent(String unformattedXml) throws Exception {
        return this.doIndent(this.parseXmlString(unformattedXml));
    }

    private String doIndent(Document document) throws Exception {
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult((OutputStream)out));
        return out.toString("utf-8");
    }

    public Document parseXmlString(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(null);
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

